<!--
  ~ Copyright (c) 1999-2022. Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- add references document label -->
  <xsl:template match="uri[@documenttype='references']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="*[not(name()='labels')]"/>
      <labels>
        <xsl:text>references</xsl:text>
        <xsl:if test="normalize-space(labels) != ''">
          <xsl:value-of select="concat(',',labels)" />
        </xsl:if>
      </labels>
    </xsl:copy>
  </xsl:template>

  <!-- only output alternate documents for footnotes, endnotes and source -->
  <xsl:template match="(xref|blockxref)[@type='alternate' and
                       not(@documenttype = ('footnotes','endnotes','source'))]">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:value-of select="if (@display='manual') then @title else @urititle" />
    </xsl:copy>
  </xsl:template>

  <!-- copy all other elements unchanged -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>