<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0">

    <xsl:param name="title" />
    <xsl:param name="documenttype" />
    <xsl:variable name="type" select="normalize-space($documenttype)" />

    <xsl:template match="/">
        <document type="{if ($type='') then 'references' else $type}" level="portable">

            <documentinfo>
                <uri title="{$title}" />
            </documentinfo>

            <!-- Title -->
            <section id="title">
                <fragment id="1">
                    <heading level="1"><xsl:value-of select="$title"/></heading>
                </fragment>
            </section>

            <!-- Table of contents -->
            <toc/>

            <!-- Cross-references -->
            <section id="xrefs">
                <xref-fragment id="2">
                    <xsl:for-each select="//uri">
                        <xsl:sort select="displaytitle" />
                        <blockxref frag="default" uriid="{@id}" type="embed">
                            <xsl:value-of select="displaytitle" />
                        </blockxref>
                    </xsl:for-each>
                </xref-fragment>
            </section>

        </document>
    </xsl:template>
</xsl:stylesheet>