create unique index host_alias_name_key on hostalias (name);

alter table content
    drop role,
    drop title,
    drop label;

alter table uri
    drop status;

alter table xlink
    drop showdefault,
    drop actuatedefault;

create table authenticator (
  authenticatorid serial primary key,
  memberid        integer      not null,
  publicid        varchar(16)  not null,
  type            varchar(20)  not null,
  name            varchar(50)  null,
  confidential    bytea        null,
  parameters      varchar(100) null,
  credentialid    bytea        null,
  publickey       bytea        null,
  verified        boolean      not null,
  signcount       integer      null,
  created         timestamp(3) not null,
  lastused        timestamp(3) null,
    unique (publicid),
    foreign key (memberid) references member(memberid)
  );

create index authenticator_credentialid_idx on authenticator(credentialid);

update database_metadata set version='6.20';