DROP TABLE VIRTUAL_DIRECTORY;

ALTER TABLE URI
    MODIFY Description TEXT CHARACTER SET utf8mb4 NULL,
    MODIFY UserTitle VARCHAR(250) CHARACTER SET utf8mb4 NULL;

ALTER TABLE HOST
  DROP Flags,
  ADD VirtualFlag TINYINT NULL;

ALTER TABLE XLINK
  ADD ThreadEndXLinkID INTEGER NULL,
  ADD FOREIGN KEY (ThreadEndXLinkID) REFERENCES XLINK(XLinkID),
  MODIFY Properties TEXT CHARACTER SET utf8mb4 NULL;

UPDATE XLINK X INNER JOIN LOCATOR_FOR_XLINK LFX ON X.XLinkID = LFX.XLinkID
  SET X.ThreadEndXLinkID = X.XLinkID
  WHERE LFX.Role IS NULL
  AND (X.ContentRole = 'Comment' OR X.ContentRole = 'File Attachment' OR X.ContentRole = 'Workflow');

UPDATE DATABASE_METADATA SET Version='5.981';