/**
 * $Id: MapValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.info;

import  java.util.Properties;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.FixtureExaminer;
import  com.idaremedia.antx.apis.Requester;

/**
 * Value URI handler that stringifies various aspects of a map data object. Is meant
 * as the map equivalent of the AntX <span class="src">$list:</span> value URI handler.
 * When generating a listing (keyset,values) you can specify a custom delimiter by
 * setting a second fragment argument after a "<span class="src">,,</span>" like:
 * <span class="src">$map:labels?keys,,|||"</span>. The general form of the URI:
 * <span class="src"><nobr>$map:maprefid[?[keys|values|size|dump|<i>key</i>][,,delim]]</nobr></span>.
 * The delim option is only relevant to the set operations.
 * <p/>
 * <b>Example Usage:</b><pre>
 *   &lt;foreach i="key" list="${<b>$map:</b>@{testproperties}?keys}" mode="local"&gt;
 *      &lt;altertask name="junitrunner" resolveproperties="yes"&gt;
 *         &lt;sysproperty key="${key}" value="${<b>$map:</b>@{testproperties}?@(key)}"/&gt;
 *      &lt;/altertask&gt;
 *   &lt;/foreach&gt;
 *
 *   &lt;foreach i="tool" list="${<b>$map:</b>@{toolnames}?values}" mode="local"&gt;
 *      &lt;mkdir dir="${reports.dir}/${tool}/${DSTAMP}"/&gt;
 *
 *   &lt;echo message="Javadoc Configuration: ${<b>$map:</b>javadoc.args}"/&gt;
 *   &lt;echo message="Metrics Tool Count: ${<b>$map:</b>toolnames?size}"/&gt;
 *
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="map"
 *           value="com.idaremedia.antx.valueuri.info.MapValueURIHandler"/&gt;
 *       &lt;parameter name="itemmap"
 *           value="com.idaremedia.antx.valueuri.info.MapValueURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public final class MapValueURIHandler extends ManageCollectionValueURIHandler
{
    /**
     * Initializes a new map examiner value uri handler.
     **/
    public MapValueURIHandler()
    {
        super();
    }


    /**
     * Extracts the bit of map information requested. Currently supports
     * four special operations: dump (also default if no fragment), keyset,
     * values, and size.
     */
    String valueFromTyped(String refid, int op, String delim, String key,
        Requester clnt)
    {
        final Project P = clnt.getProject();

        if (delim==null) {
            delim = AntX.DEFAULT_DELIMITER;
        }

        if (FixtureExaminer.usableReference(P,refid)) {
            Properties all = FixtureExaminer.getReferencedProperties(P,refid,null);
            if (all!=null) {
                switch(op) {
                    case SIZE: {
                        return String.valueOf(all.size());
                    }
                    case KEYSET: {
                        return listFrom(all.keySet().iterator(),delim);
                    }
                    case VALUES: {
                        return listFrom(all.values().iterator(),delim);
                    }
                    case LOOKUP: {
                        return all.getProperty(key);
                    }
                    case DUMP: {
                        return String.valueOf(all);
                    }
                }
            }//all!=null
        }//refid-usable

        return null;
    }
}

/* end-of-MapValueURIHandler.java */