/**
 * $Id: DefaultsPropertyNameURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.info;

import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Simple value URI handler that returns name of the project property that caller
 * must set to control named default. To obtain the result, the current Iteration's
 * @linkplain Defaults Defaults} object is queried. If the Defaults object does not
 * recognize the default, <i>null</i> is returned. The general format of the URI:
 * <span class="src">$defaultsproperty:default-name</span>.
 * <p/>
 * <b>Example Usage:</b><pre>
 *    &lt;property name="${$defaultsproperty:shortlocations}" value="yes"/&gt;
 *    &lt;do if="${$defaultsproperty:passwordfile}"&gt;...
 *
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="defaultsproperty"
 *             value="com.idaremedia.antx.valueuri.info.DefaultsPropertyNameURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 * @see       DefaultsValueURIHandler
 **/

public final class DefaultsPropertyNameURIHandler extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new defaults property name uri handler.
     **/
    public DefaultsPropertyNameURIHandler()
    {
    }


    /**
     * Returns the associated default setting if possible. Will
     * return <i>null</i> if default name unrecognized.
     **/
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        if (uriFragment.length()>0) {
            String fragment = Tk.lowercaseFrom(uriFragment);
            return Iteration.defaultdefaults().propertyFrom(fragment,clnt);
        }
        return null;
    }
}

/* end-of-DefaultsPropertyNameURIHandler.java */