/**
 * $Id: EqualDateTimeValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.datetime;

import  java.text.ParseException;
import  java.text.SimpleDateFormat;
import  java.util.Date;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.DateTimeFormat;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Value URI handler that compares two timestamps for equality. Both timestamps must
 * be supplied (or implied); otherwise the handler returns <i>null</i>. 
 * <p/>
 * <b>Example Usage:</b><pre>
 *    &lt;do true="${$<b>equaldate:</b>@(crdate1),,@(crdate2)}"&gt;
 *        ...
 * 
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="samedate"
 *             value="com.idaremedia.antx.valueuri.datetime.EqualDateTimeValueURIHandler"/&gt;
 *       &lt;parameter name="equaldate"
 *             value="com.idaremedia.antx.valueuri.datetime.EqualDateTimeValueURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public class EqualDateTimeValueURIHandler extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new same datetime value comparer handler.
     **/
    public EqualDateTimeValueURIHandler()
    {
    }


    /**
     * Converts the comparision operation into a normalized true|false
     * string. Will return <i>null</i> if uri is malformed or unable to
     * parse date information.
     */
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        uriFragment = Tk.resolveString(clnt.getProject(),uriFragment,true);

        String ds1=null,ds2=null;
        final int N = uriFragment.length();
        int j,i;
        String fs = null;
 
        i = uriFragment.indexOf(",,");
        if (i>0) {
            ds1 = uriFragment.substring(0,i);
            i += 2;
            if (i<N) {
                j = uriFragment.indexOf("?",i);
                if (j<0) {
                    ds2 = uriFragment.substring(i);
                } else {
                    ds2 = uriFragment.substring(i,j);
                    j++;
                    if (j<N) {
                        fs = uriFragment.substring(j);
                    }
                }
            }
        }
        if (ds1!=null && ds2!=null) {
            Date d1=null,d2=null;
            SimpleDateFormat df = DateTimeFormat.CHANGELOG;
            if (fs!=null) {
                df = new SimpleDateFormat(fs);
            }
            synchronized(df) {
                try {
                    d1 = df.parse(ds1);
                } catch(ParseException px) {/*burp*/}
                try {
                    d2 = df.parse(ds2);
                } catch(ParseException px) {/*burp*/}
            }
            df = null;
            if (d1!=null && d2!=null) {
                return String.valueOf(compare(d1,d2));
            }
        }
        return null;
    }
    

    /**
     * Perform the comparision operation and return value as a match
     * or not. Will do an equality test by default; subclasses should
     * override to be perform other comparison tests.
     * @param d1 first date in uri (non-null)
     * @param d2 second date in uri (non-null)
     * @return <i>true</i> if comparision condition met. 
     */
    protected boolean compare(Date d1, Date d2)
    {
        return d1.equals(d2);
    }
}

/* end-of-EqualDateTimeValueURIHandler.java */