/**
 * $Id: ZeroCheckValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.condition;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Value URI handler that returns the true if the incoming source value is "0". Useful
 * for testing the initial boundary value of a loop cursor when creating compound
 * strings. An empty fragment returns <span class="src">false</span>.
 * <p/>
 * <b>Example Usage:</b><pre>
 *   &lt;foreach i="i" in="0,10" mode="local"&gt;
 *      &lt;do false="${<b>$iszero:</b>@(i)}"&gt;&#8230;
 *
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="zero"
 *           value="com.idaremedia.antx.valueuri.condition.ZeroCheckValueURIHandler"/&gt;
 *       &lt;parameter name="iszero"
 *           value="com.idaremedia.antx.valueuri.condition.ZeroCheckValueURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public final class ZeroCheckValueURIHandler extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new zerocheck value uri handler.
     **/
    public ZeroCheckValueURIHandler()
    {
        super();
    }


    /**
     * Returns <span class="src">true</span> iff the incoming fragment
     * resolves to the value "0".
     **/
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        String value = Tk.resolveString(clnt.getProject(),uriFragment,true);
        return String.valueOf("0".equals(value));
    }
}

/* end-of-ZeroCheckValueURIHandler.java */