/**
 * $Id: TFValueNormalizer.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.condition;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Value URI handler that tries to normalize an Ant-friendly boolean string to either
 * "<span class="src">true</span>" or "<span class="src">false</span>". Usually called
 * <span class="src">$truefalse:</span>. You can also specify your own true and false
 * normalized strings by setting two fragment parameters (separated by 
 * "<span class="src">,,</span>"). The first argument is the true string, the second is
 * the false string.
 * <p>
 * <b>Example Usage:</b><pre>
 *    &lt;domatch value="${<b>$truefalse:</b>@(boolean.property)}" haltifnomatch="yes"&gt;
 *       &lt;equals value="true"&gt;
 *          ...
 *       &lt;equals value="false"&gt;
 *          ...
 *    &lt;/domatch&gt;
 * 
 *    &lt;checkpoint-usertests status="${$isset:uat.failed|$truefalse:?PASS,,FAIL}"/&gt;
 * 
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="truefalse"
 *             value="com.idaremedia.antx.valueuri.condition.TFValueNormalizer"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public final class TFValueNormalizer extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new truefalse value uri handler.
     **/
    public TFValueNormalizer()
    {
        super();
    }


    /**
     * Converts a Ant-isque boolean string into a normalized 
     * "<span class="src">true</span>" or "<span class="src">false</span>".
     * If a custom pair of true/false strings specified as query parameters,
     * one of these strings will be returned instead.
     **/
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        String truefalse = uriFragment;
        String T = Strings.TRUE;
        String F = Strings.FALSE;
        
        int i= uriFragment.lastIndexOf("?");
        if (i>=0) {
            truefalse = uriFragment.substring(0,i++);
            if (i<uriFragment.length()) {
                String TF = uriFragment.substring(i);
                int j = TF.lastIndexOf(",,");
                if (j>=0) {//NB: allow for empty true strings!
                    T = TF.substring(0,j);
                    j += 2;
                    F = TF.substring(j);
                } else {
                    T = TF;
                }
            }
        }
        truefalse = Tk.resolveString(clnt.getProject(),truefalse,true);
        Boolean B = Tk.string2PosBool(truefalse);
        if (B==Boolean.FALSE) {
            B = Tk.string2NegBool(truefalse);
            if (B==Boolean.TRUE) {
                return null;
            }
        }
        return B.booleanValue() ? T : F;
    }
}


/* end-of-TFValueNormalizer.java */