/**
 * $Id: HTC.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2002-2003,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ut;

import  java.io.File;
import  java.io.InputStream;
import  java.io.PrintStream;
import  java.net.URL;

import  org.apache.tools.ant.BuildFileTest;
import  org.apache.tools.ant.BuildException;
import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.Problems;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Harness-Test-Case(<i>HTC</i>) plucked from the JWare/foundation/ut package (ssmc).
 * Changes from the source HTC class:<ul>
 *   <li> Batched failure support removed</li>
 *   <li> Subclasses from the ant build file test helper instead of the JUnit test</li>
 *   <li> Adds dependency on AntX.Tk class for some URL->file conversion utilities</li>
 *   <li> Introduced some Ant buildfile-specific assertion helpers
 * </ul>
 *
 * @since    JWare0.6
 * @author   ssmc, &copy;2002-2003,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5.1
 * @.safety  single
 * @.group   impl,test
 * @.expects junit3.7+
 **/

public abstract class HTC extends BuildFileTest
{
    /**
     * Creates new specific HTC as part of a labeled group.
     * @param groupid group identifier (non-null)
     * @param methodName test method's name (non-null)
     **/
    protected HTC(String groupid, String methodName)
    {
        super(methodName);
        m_groupid= groupid==null ? "" : groupid;
        initIfMustBlockCDATA();
    }


    /**
     * Creates new specific HTC.
     **/
    protected HTC(String methodName)
    {
        super(methodName);
        initIfMustBlockCDATA();
    }


    /**
     * Creates new HTC for <i>checkBaseline</i> method.
     **/
    protected HTC()
    {
        super("checkBaseline");
        initIfMustBlockCDATA();
    }

// ---------------------------------------------------------------------------------------------------------|
// Internal Test Contract-Verification:
// ---------------------------------------------------------------------------------------------------------|

    /**
     * Fails a test with the given message.
     **/
    public static void cvfail(String message)
    {
        throw new TestError(message);
    }


    /**
     * Precondition implementation: requires given condition to be <code>true</code>
     * on entry to a method or block of code.
     **/
    public final void require_(boolean cond, String msg)
    {
        if (!cond) {
            cvfail("require:"+msg);
        }
    }


    /**
     * Postcondition implementation: requires given condition to be <code>true</code>
     * on exit from a method or block of code.
     **/
    public final void ensure_(boolean cond, String msg)
    {
        if (!cond) {
            cvfail("ensure:"+msg);
        }
    }


    /**
     * Invariant implementation: requires given condition to be <code>true</code>
     * at some well defined points (entry and/or exit to method and or blocks
     * of codes).
     **/
    public final void verify_(boolean cond, String msg)
    {
        if (!cond) {
            cvfail("verify:"+msg);
        }
    }


    /**
     * Use to write out internal class errors conditions (not failures).
     * @param tbtn the throwable that was caught
     * @param msg the error message (non-<code>null</code>)
     **/
    public void unexpected_(Throwable tbtn, String msg)
    {
        System.err.println("** ERROR[internal]:"+msg+tbtn);
    }


    /**
     * Use to write out internal class errors conditions (not failures).
     * @param msg the error message (non-<code>null</code>)
     **/
    protected void irupted_(InterruptedException ix, String msg)
    {
        System.err.println("** WARNG[internal]: Interrupted Thread:"+msg+ix);
        Thread.currentThread().interrupt();
    }


// ---------------------------------------------------------------------------------------------------------|
// Brain-Dead support for manual 'Eyeballing' test-generated output:
// ---------------------------------------------------------------------------------------------------------|

    /** Used to uniqify tests labels. **/
    private String m_groupid= "";

    /** Default output stream (System.out). Subclasses can modify in their setUp. **/
    protected PrintStream m_stdout= System.out;


    /**
     * Ugly. Until I think of a better way of doing this, it works.
     **/
    protected final boolean isBlockedCDATA(String s)
    {
        if (m_blockCDATA) {
            if (s.indexOf("<![CDATA[")>=0) {
                return true;//burp
            }
        }
        return false;
    }

    /**
     * Convenient for diagnostics output from test (method).
     * @see #setupStandardOut
     **/
    protected void println(String s)
    {
        if (!isBlockedCDATA(s)) {
            m_stdout.println(s);
        } else {
            m_stdout.println("** ALERT[internal]: BLOCKED");
        }
    }


    /**
     * Another convenience for diagnostics output from test (method).
     * @see #setupStandardOut
     **/
    protected void println(String label, Object o)
    {
        String s= String.valueOf(o);
        if (!isBlockedCDATA(s)) {
            m_stdout.println(label+"\n"+s);
        } else {
            m_stdout.println("** ALERT[internal]: BLOCKED");
        }
    }


    /**
     * Convenience for println just a newline.
     **/
    protected final void println()
    {
        println("");
    }


    /**
     * Called by subclass's <code>setUp</code> if custom standard
     * output PrintStream needed.
     * @param outp standard output stream
     * @see #println
     **/
    protected final void setupStandardOut(PrintStream outp)
    {
        require_(outp!=null,"stdout- nonzro stream");
        m_stdout= outp;
    }


// ---------------------------------------------------------------------------------------------------------|
// Retrieving Test Input Data
// ---------------------------------------------------------------------------------------------------------|


    /**
     * Helper to load an input file located in class hierarchy (with tests)
     **/
    protected final InputStream getFileResourceAsStream(String resource, Class forClass)
    {
        require_(resource!=null && forClass!=null,"getRez- nonzro inputs");
        InputStream resFile = forClass.getResourceAsStream(resource);
        if (resFile==null) { resFile= ClassLoader.getSystemResourceAsStream(resource); }
        assertNotNil(resFile,"Class "+forClass.getName()+" input resource' ("+resource+")'");
        return resFile;
    }


    /**
     * Helper to load an input file for this test.
     **/
    protected final InputStream getFileResourceAsStream(String resource)
    {
        return getFileResourceAsStream(resource, getClass());
    }


    /**
     * Helper to convert a class resource's location to a standard File. Fails
     * if unable to locate file in class's location or system class path.
     * @param forClass the class with which resource associated (non-null)
     * @param resource the resource name (non-null)
     * @return file reference for resource
     **/
    protected final File getFileResource(String resource, Class forClass)
    {
        require_(forClass!=null,"getFil- nonzro clas");
        require_(resource!=null,"getFil- nonzro rez");

        final String what = "Class "+forClass.getName()+" input resource' ("+resource+")'";

        URL url = forClass.getResource(resource);
        if (url==null) { url = ClassLoader.getSystemResource(resource); }
        assertNotNil(url, what);

        File f = Tk.toFile(url);
        assertNotNil(f, what);
        assertTrue(f.canRead(), "CanRead: "+what);

        return f;
    }


    /**
     * Helper to get an input file location for this test.
     **/
    protected final File getFileResource(String resource)
    {
        return getFileResource(resource, getClass());
    }


    /**
     * Initialization that most tests want to do in their setUp()
     * method.
     **/
    protected final void configureProjectFromResource(String resource)
    {
        configureProject(getFileResource(resource).getPath());
    }


// ---------------------------------------------------------------------------------------------------------|
// Batchable Failures Support: *** S T U B I F I E D  for outside JWare/ut (ssmc) ***
// ---------------------------------------------------------------------------------------------------------|


    /**
     * Extension of JUnit's base fail method, that works for multi-failure
     * recording. If current thread not in batch-mode, immediately generates
     * failure.
     **/
    public static final void failASAP(String msg)
    {
        fail(msg);// [batch-fail-modified]
    }


    /**
     * Alternative to {@linkplain #failASAP(java.lang.String)} that takes a
     * Throwable and uses it's message as the failure's information.
     * @param t triggering problem (non-null)
     **/
    public static final void failASAP(Throwable t)
    {
        fail(t.getMessage()); // [batch-fail-modified]
    }


    /**
     * Helper that generates the appropriate assertion message for failure due
     * to unequal actual and expected.
     **/
    public static final void failNotEqualASAP(Object actual, Object expected, String msg)
    {
        String formatted="";
        if (msg!=null) {
            formatted = msg+" ";
        }
        //NB: *ICK* but, 'failASAP' unrolled to lessen stack (ssmc)
        formatted = formatted+"expected:[["+expected+"]] but was:[["+actual+"]]";
        fail(formatted); // [batch-fail-modified]
    }


    /**
     * Helper that generates the appropriate assertion message for failure due
     * to unequal actual and expected.
     **/
    public static final void failEqualASAP(Object actual, Object expected, String msg)
    {
        String formatted="";
        if (msg!=null) {
            formatted = msg+" ";
        }
        //NB: *ICK* but, 'failASAP' unrolled to lessen stack (ssmc)
        formatted = formatted+"expected NOT to equal:[["+expected+"]]";
        fail(formatted); // [batch-fail-modified]
    }


// ---------------------------------------------------------------------------------------------------------|

    /**
     * Optional notification that test method about to be executed.
     **/
    protected void enter_(String methodName)
    {
        println("\n------("+m_groupid+methodName+"[Ant="+AntX.ANT_VERSIONSTRING+"]): \n");
    }


    /**
     * Optional notification that test method has finished.
     **/
    protected void leave_(String methodName)
    {
    }


    /**
     * Called by TestResult to execute HTC. Tweaked to generate proper 'enter' and
     * 'leave' notifications and to ensure batched failures are reported.
     **/
    public void runBare() throws Throwable
    {
        AntXFixture.reset(Problems.IgnoringHandler);//@since JWare/AntX 0.4 (ssmc)
        enter_(getName());
        setUp();
        try {
            runTest();
            // [batch-fail-modified]
        } finally {
            // [batch-fail-modified]
            tearDown();
            leave_(getName());
        }
    }


    /**
     * Skip inherited teardown that expects a build file if no such file loaded.
     * @since JWare/AntXtras 0.5.1
     */
    protected void tearDown() throws Exception {
        if (getProject()!=null && getProject().getTargets()==null) {
            super.tearDown();
        }
    }

// ---------------------------------------------------------------------------------------------------------|
// Essentials overridden from JUnit's Assertion API for batching failures and signatures:
// ---------------------------------------------------------------------------------------------------------|

    /**
     * Barfs with an assertion failure around given throwable's message.
     * @see #failASAP(java.lang.Throwable)
     **/
    public static final void fail(Throwable t)
    {
        fail(t.getMessage());
    }


    /**
     * Asserts to objects are equivalent. For non-null entities, equivalence is
     * defined by the expected object's <i>equals</i> method.
     **/
    public static final void assertEqual(Object actual, Object expected, String msg)
    {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }

        //NB: *ICK* but, 'failNotEqualASAP' unrolled to lessen stack (ssmc)
        String formatted="";
        if (msg!=null) {
            formatted = msg+" ";
        }
        formatted = formatted+"expected:[["+expected+"]] but was:[["+actual+"]]";
        fail(formatted);// [batch-fail-modified]
    }


    /**
     * Asserts that two objects are not equivalent. For non-null entities, equivalence
     * is defined by the expected object's <i>equals</i> method.
     **/
    public static final void assertNotEqual(Object actual, Object expected, String msg)
    {
        if (expected==null && actual!=null) {
            return;
        }
        if (expected!=null && actual==null) {
            return;
        }
        if (!actual.equals(expected)) {
            return;
        }

        //NB: *ICK* but, 'failEqualASAP' unrolled to lessen stack (ssmc)
        String formatted="";
        if (msg!=null) {
            formatted = msg+" ";
        }
        formatted = formatted+"expected NOT to equal:[["+expected+"]]";
        fail(formatted);// [batch-fail-modified]
    }

// ---------------------------------------------------------------------------------------------------------|

    /**
     * Asserts that to object references are identical (i&#46;e&#46; points to the same
     * thing).
     **/
    public static final void assertIdent(Object actual, Object expected, String msg)
    {
        if (expected==actual) {
            return;
        }
        String formatted="";
        if (msg!=null) {
            formatted = msg+" ";
        }
        failASAP(formatted+"expected identical");
    }


    /** Asserts that two given objects refer to same object reference. **/
    public static final void assertIdent(Object actual, Object expected)
    {
        assertIdent(expected,actual,null);
    }


    /**
     * Asserts that to object references are NOT identical. Does not check
     * equivalence of objects.
     **/
    public static final void assertNotIdent(Object actual, Object expected, String msg)
    {
        if (expected==actual) {
            String formatted="";
            if (msg!=null) {
                formatted = msg+" ";
            }
            failASAP(formatted+"expected NOT to be identical");
        }
    }


    /** Asserts that two given objects do not refer to same object reference. **/
    public static final void assertNotIdent(Object actual, Object expected)
    {
        assertNotIdent(actual,expected,null);
    }

// ---------------------------------------------------------------------------------------------------------|

    /**
     * Asserts that value is false. More readable test since it makes a
     * negative expectation explicit.
     **/
    public static final void assertFalse(boolean actual)
    {
        assertEqual(actual, false);
    }


    /**
     * Asserts that value is false. More readable test since it makes a
     * negative expectation explicit.
     **/
    public static final void assertFalse(boolean actual, String msg)
    {
        assertEqual(actual,false,msg);
    }


    /**
     * Asserts that value is true. More readable test since it makes a
     * positive expectation explicit.
     **/
    public static final void assertTrue(boolean actual)//for completeness
    {
        assertEqual(actual,true);
    }


    /**
     * Asserts that value is true. More readable test since it makes a
     * positive expectation explicit.
     **/
    public static final void assertTrue(boolean actual, String msg)
    {
        assertEqual(actual,true,msg);
    }

// ---------------------------------------------------------------------------------------------------------|

    /** Asserts that the given object is <i>null</i>. **/
    public static final void assertNil(Object actual)
    {
        assertNil(actual,null);
    }

    /** Asserts that the given object is <i>null</i>. **/
    public static final void assertNil(Object actual, String msg)
    {
        //NB: *ICK* but, 'failASAP' unrolled to lessen stack (ssmc)

        //NB: this is specified here since failed-assertion messages based on
        //    using assertFalse never made sense...one always had to manually work
        //    back from 'false' is actually 'not-nil' or something...

        if (actual!=null) {
            String formatted="";
            if (msg!=null) {
                formatted = msg+" ";
            }

            formatted = formatted+"expected TO BE NULL but was not.";
            fail(formatted);
        }
    }

    /** Asserts that the given object is <em>not</em> <i>null</i>. **/
    public static final void assertNotNil(Object actual)
    {
        assertNotNil(actual,null);
    }

    /** Asserts that the given object is <em>not</em> <i>null</i>. **/
    public static final void assertNotNil(Object actual, String msg)
    {
        //NB: *ICK* but, 'failASAP' unrolled to lessen stack (ssmc)

        //NB: this is specified here since failed-assertion messages based on
        //    using assertFalse never made sense...one always had to manually work
        //    back from 'false' is actually 'not-nil' or something...

        if (actual==null) {
            String formatted="";
            if (msg!=null) {
                formatted = msg+" ";
            }

            formatted = formatted+"expected NOT TO BE NULL but was.";
            fail(formatted);
        }
    }

// ---------------------------------------------------------------------------------------------------------|
// HTC/JWare versions of a type-safe Assertion API:
// ---------------------------------------------------------------------------------------------------------|

    /** Asserts that an value is equivalent to its expected value. **/
    public static final void assertEqual(Object actual, Object expected)
    {
        assertEqual(actual,expected,null);
    }

    /** Asserts that a boolean value is as expected. **/
    public static final void assertEqual(boolean actual, boolean expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that a boolean value is as expected. **/
    public static final void assertEqual(boolean actual, boolean expected, String msg)
    {
        assertEqual(actual ? Boolean.TRUE : Boolean.FALSE, expected ? Boolean.TRUE : Boolean.FALSE, msg);
    }

    /** Asserts that a character is as expected. **/
    public static final void assertEqual(char actual, char expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that a character is as expected. **/
    public static final void assertEqual(char actual, char expected, String msg)
    {
        assertEqual(new Character(actual),new Character(expected),msg);
    }

    /** Asserts that a float is equal to expected value within a specified delta. **/
    public static final void assertEqual(float actual, float expected, float delta)
    {
        assertEqual(actual,expected,delta,null);
    }
    /** Asserts that a float is equal to expected value within a specified delta. Infinites must match. **/
    public static final void assertEqual(float actual, float expected, float delta, String msg)
    {
        if (Float.isInfinite(expected)) {
            if (!(expected==actual)) {
                failNotEqualASAP(new Float(actual), new Float(expected), msg);
            }
        } else if (!(Math.abs(expected-actual)<=delta)) {
            failNotEqualASAP(new Float(actual), new Float(expected), msg);
        }
    }
    /** Asserts that a float is equal to an expected value. **/
    public static final void assertEqual(float actual, float expected)
    {
        assertEqual(actual,expected,0f,null);
    }

    /** Asserts that a double is equal to expected value within a specified delta.**/
    public static final void assertEqual(double actual, double expected, double delta)
    {
        assertEqual(actual,expected,delta,null);
    }
    /** Asserts that a double is equal to expected value within a specified delta. Infinites must match. **/
    public static final void assertEqual(double actual, double expected, double delta, String msg)
    {
        if (Double.isInfinite(expected)) {
            if (!(expected==actual)) {
                failNotEqualASAP(new Double(actual), new Double(expected), msg);
            }
        } else if (!(Math.abs(expected-actual)<=delta)) {
            failNotEqualASAP(new Double(actual), new Double(expected), msg);
        }
    }
    /** Asserts that a double is equal to an expected value. **/
    public static final void assertEqual(double actual, double expected)
    {
        assertEqual(actual,expected,0d,null);
    }

    /** Asserts that a byte is equal to an expected value. **/
    public static final void assertEqual(byte actual, byte expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that a byte is equal to an expected value. **/
    public static final void assertEqual(byte actual, byte expected, String msg)
    {
        assertEqual(new Byte(actual),new Byte(expected),msg);
    }

    /** Asserts that a short is equal to an expected value. **/
    public static final void assertEqual(short actual, short expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that a short is equal to an expected value. **/
    public static final void assertEqual(short actual, short expected, String msg)
    {
        assertEqual(new Short(actual), new Short(expected), msg);
    }

    /** Asserts that an integer is equal to an expected value. **/
    public static final void assertEqual(int actual, int expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that an integer is equal to an expected value. **/
    public static final void assertEqual(int actual, int expected, String msg)
    {
        assertEqual(new Integer(actual), new Integer(expected), msg);
    }

    /** Asserts that a long is equal to an expected value. **/
    public static final void assertEqual(long actual, long expected)
    {
        assertEqual(actual,expected,null);
    }
    /** Asserts that a long is equal to an expected value. **/
    public static final void assertEqual(long actual, long expected, String msg)
    {
        assertEqual(new Long(actual), new Long(expected), msg);
    }

// ---------------------------------------------------------------------------------------------------------|
// HTC/JWare versions of a negative type-safe Assertion API:
// ---------------------------------------------------------------------------------------------------------|

    /**
     * Asserts that two objects are not equivalent. For non-null entities, equivalence
     * is defined by the expected object's <i>equals</i> method.
     **/
    public static final void assertNotEqual(Object actual, Object expected)
    {
        assertNotEqual(actual,expected,null);
    }

    /** Asserts that two booleans are different. **/
    public static void assertNotEqual(boolean actual, boolean expected, String msg)
    {
        assertNotEqual(new Boolean(actual), new Boolean(expected), msg);
    }
    /** Asserts that two booleans are different. **/
    public static void assertNotEqual(boolean actual, boolean expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /** Asserts that two characters are different. **/
    public static final void assertNotEqual(char actual, char expected, String msg)
    {
        assertNotEqual(new Character(actual), new Character(expected), msg);
    }
    /** Asserts that two characters are different. **/
    public static void assertNotEqual(char actual, char expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /** Asserts that two bytes are different. **/
    public static void assertNotEqual(byte actual, byte expected, String msg)
    {
        assertNotEqual(new Byte(actual), new Byte(expected), msg);
    }
    /** Asserts that two bytes are different. **/
    public static void assertNotEqual(byte actual, byte expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /** Asserts that two shorts are different. **/
    public static void assertNotEqual(short actual, short expected, String msg)
    {
        assertNotEqual(new Short(actual), new Short(expected), msg);
    }
    /** Asserts that two shorts are different. **/
    public static void assertNotEqual(short actual, short expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /** Asserts that two integers are different. **/
    public static void assertNotEqual(int actual, int expected, String msg)
    {
        assertNotEqual(new Integer(actual), new Integer(expected), msg);
    }
    /** Asserts that two integers are different. **/
    public static void assertNotEqual(int actual, int expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /** Asserts that two longs are different. **/
    public static void assertNotEqual(long actual, long expected, String msg)
    {
        assertNotEqual(new Long(actual), new Long(expected), msg);
    }
    /** Asserts that two longs are different. **/
    public static void assertNotEqual(long actual, long expected)
    {
        assertNotEqual(actual, expected, null);
    }

    /**
     * Asserts that two floats differ by more than a specified delta.
     **/
    public static void assertNotEqual(float actual, float expected, float delta)
    {
        assertNotEqual(actual,expected,delta,null);
    }
    /**
     * Asserts that two floats differ by more than a specified delta.
     **/
    public static void assertNotEqual(float actual, float expected, float delta, String msg)
    {
        if (Float.isInfinite(expected)) {
            if (expected==actual) {
                failEqualASAP(new Float(actual),new Float(expected),msg);
            }
        } else if ((Math.abs(expected-actual)<=delta)) {
            failEqualASAP(new Float(actual), new Float(expected), msg);
        }
    }
    /**
     * Asserts that two floats differ.
     **/
    public static void assertNotEqual(float actual, float expected)
    {
        assertNotEqual(actual,expected,0f,null);
    }

    /**
     * Asserts that two doubles differ by more than a specified delta.
     **/
    public static void assertNotEqual(double actual, double expected, double delta, String msg)
    {
        if (Double.isInfinite(expected)) {
            if (expected==actual) {
                failEqualASAP(new Double(actual),new Double(expected),msg);
            }
        } else if ((Math.abs(expected-actual)<=delta)) {
            failEqualASAP(new Double(actual), new Double(expected), msg);
        }
    }
    /**
     * Asserts that two doubles differ by more than a specified delta.
     **/
    public static void assertNotEqual(double actual, double expected, double delta)
    {
        assertNotEqual(actual,expected,delta,null);
    }
    /**
     * Asserts that two doubles differ.
     **/
    public static void assertNotEqual(double actual, double expected)
    {
        assertNotEqual(actual,expected,0d,null);
    }

// ---------------------------------------------------------------------------------------------------------|
// HTC/JWare additions to Assertion API (ALL SAFE FOR BATCHED FAILURES):
// ---------------------------------------------------------------------------------------------------------|

    /**
     * Helper that verifies a thrown exception contains a distinguishing tag.
     **/
    protected final void assertExpected(Throwable thr, String tag)
    {
        require_(thr!=null, "verfyXpected- nonzro throwable");
        String s= thr.getMessage();
        if (s==null) {
            failASAP("Barfage from("+tag+") expected but got NULL message");
        } else if (s.indexOf(tag)<0) {
            failASAP("Barfage from("+tag+") expected but not found. Actual:[["+s+"]]");
        }
    }


    /**
     * Helper that verifies a thrown exception is of an expected class and
     * contains a distinguishing tag.
     **/
    protected final void assertExpected(Throwable thr, Class thrClass, String tag)
    {
        require_(thr!=null, "verfyXpected- nonzro throwable");
        if (!thrClass.isAssignableFrom(thr.getClass())) {
            failASAP("Barfage from("+tag+") expected throwable of class[["+thrClass.getName()+"]]. "+
                     "Actual class[["+thr.getClass().getName()+"]]");
        } else {
            assertExpected(thr,tag);
        }
    }



    /** Asserts that the given string is non-null, not empty, and contains
        characters other than whitespace (as defined by Java specification). **/
    public final void assertNotWhitespace(String s)
    {
        assertNotWhitespace(s,"Is whitespace?");
    }


    /** Asserts that the given string is non-null, not empty, and contains
        characters other than whitespace (as defined by Java specification). **/
    public final void assertNotWhitespace(String s, String msg)
    {
        if (s==null) {
            failEqualASAP(s,"NULL string",msg);
        } else if (s.length()==0) {
            failEqualASAP(s,"zero length string",msg);
        } else {
            for (int i=0,n=s.length();i<n;i++) {
                if (!Character.isWhitespace(s.charAt(i))) {
                    return;
                }
            }
        }
        failASAP(msg);
    }


// ---------------------------------------------------------------------------------------------------------|
// Custom assertions for BuildFile testing:
// ---------------------------------------------------------------------------------------------------------|

    /**
     * Assert that the given message has been logged when running
     * the given target.
     */
    protected void expectFullLogContaining(String target, String log) {
        executeTarget(target);
        String realLog = getFullLog();
        assertTrue("expecting fulllog to contain \""+log+"\" log was \""
                   + realLog + "\"",
                   realLog.indexOf(log) >= 0);
    }


    /**
     * Runs target and automatically writes the log (error/warn/info)
     * to this test's output stream.
     **/
    protected final String runTarget(String target)
    {
        require_(target!=null,"runTarget- nonzro name");
        String log=null;
        try {
            executeTarget(target);
        }finally {
            log= getLog();
            println("ANT's INFO+WARN+ERR LLLOOOGGG: ----",log);
        }
        return log;
    }


    /**
     * Runs target and automatically writes the full log (everything)
     * to this test's output stream.
     **/
    protected final String runTargetDumpFullLog(String target)
    {
        try {
            return runTarget(target);
        }finally {
            println();
            println("FFFUUUUUULLLLL LOG:",getFullLog());
        }
    }


    /**
     * Extension of {@linkplain #runTarget runTarget} the also checks
     * that there's not output in the standard ant logs.
     **/
    protected final String runTargetNoOutput(String target)
    {
        String log = runTarget(target);
        assertEqual(log.length(),0,"Generated log output");
        return log;
    }


    /**
     * Verify a marker string occurs only an expected number of times in
     * given output log.
     **/
    protected final void verifyOccurances(final String log, final String ofStr,
                                          final int Nexpected)
    {
        int Nfound = 0;
        int i, from=0;
        while ((i=log.indexOf(ofStr,from))>=0) {
            Nfound++;
            from = i+ofStr.length();
        }
        assertTrue("Expecting Log to contain \""+Nexpected+"\" occurances of ["+ofStr+
                   "] but Log was \"" + log + "\"",
                   Nfound==Nexpected);
    }


    /**
     * Like inherited expectBuildException except automatically writes
     * the standard err/warn/info log to this test's output stream.
     **/
    protected final String runExpecting(String target, String cause)
    {
        expectBuildException(target,cause);
        String log = getLog();
        println("ANT's INFO+WARN+ERR LLLOOOGGG: ----",log);
        return log;
    }


    /**
     * Verify the order in which certain marker string logged to an
     * output stream.
     **/
    protected final void verifyOutputInOrder(final String log, String[] strings)
    {
        final int Nmax = log.length();
        int ilast=0;
        for (int i=0;i<strings.length;i++) {
            int at = log.indexOf(strings[i], ilast);
            assertTrue("Expecting Log to contain \""+strings[i]+"\" in relative position ["+i+
                       "] but Log was \"" + log + "\"",
                       at>=0);
            ilast = at+strings[i].length();
            if ((ilast==Nmax) && (i!=strings.length-1)) {
                fail("Expecting Log to contain more messages("+strings[i+1]+", ...etc.) but "+
                     "Log is ended after ("+strings[i]+") Log was \""+ log + "\"");
            }
        }
    }


    /**
     * Checks whether a 'broken' build xml file can be loaded. Used for
     * tasks that verify structure as they're being built at parse-time.
     **/
    protected final void verifyCantLoadFile(String resource, String problem)
    {
        try {
            configureProjectFromResource(resource);
            if (AntX.STRICT_SCRIPTS || "true".equals(System.getProperty(AntX.STRICT_SCRIPTCHECK_PROP))) {
                runTarget(getProject().getDefaultTarget());//@since Ant1.6+UnknownElements!
            }
            fail("Should not be able parse file with "+problem+
                 "! Strict="+AntX.STRICT_SCRIPTS);
        }catch(BuildException x) {
            println("LOADFILE-BARFAGE: ",x.getMessage());
            /*burp*/
        }
    }



// ---------------------------------------------------------------------------------------------------------|
// HTC compatibility with default JUnitReport (hacked for now).
// JUnitReport gets very confused by xml written to either System.out or System.err.
// For now we silently eat anything written that contains CDATA flag!
// ---------------------------------------------------------------------------------------------------------|

    private boolean m_blockCDATA=false;

    private void initIfMustBlockCDATA()
    {
        String s;
        s= readEnv(HTestConstants.BLOCK_CDATA_STDIO);
        if (s!=null) {
            s= s.toLowerCase();
        }
        if ("true".equals(s) || "on".equals(s)) {
            m_blockCDATA=true;
        }
    }

    private String readEnv(String name)
    {
        try {
            return System.getProperty(name);
        } catch(SecurityException sx) {
        }
        return null;//for our purposes
    }

}

/* end-of-HTC.java */
