/**
 * $Id: AllTests.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                                 EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.testsmodule.tasks;

import  junit.framework.TestSuite;

/**
 * Install full testsuite for all of <i>JWare/AntX/tasks</i> classes.
 *
 * @since   JWare/AntX 0.2
 * @author  ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @.safety single
 * @.group  impl,test
 **/

public class AllTests extends TestSuite
{
    /**
     * Creates a jumbo-suite of all <i>JWare/AntX/tasks</i> testsuites.
     **/
    public AllTests()
    {
        super();
        setName("JWare/AntX/tasks TestSuite");

        this.addTest(com.idaremedia.antx.testsmodule.core.AllModuleTests.suite());
        this.addTest(com.idaremedia.antx.testsmodule.flowcontrol.AllModuleTests.suite());
        this.addTest(com.idaremedia.antx.testsmodule.feedback.AllModuleTests.suite());
        this.addTest(AllInstallTests.suite());
    }


    /**
     * Create meta suite of all JWare/AntX/tasks full testsuites.
     **/
    public static TestSuite suite()
    {
        return new AllTests();
    }
}

/* end-of-AllTests.java */
