/**
 * $Id: VerifyFixtureTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.condition.VerifyFixture
 * VerifyFixture}.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class VerifyFixtureTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new VerifyFixtureTest testcase.
     **/
    public VerifyFixtureTest(String methodName)
    {
        super("VerifyFixture::",methodName);
    }


    /**
     * Create full test suite for AssertTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(VerifyFixtureTest.class);
    }


    /**
     * Create baseline test suite for AssertTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("check.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseIsNotWhitespace_AntX03()
    {
        runExpecting("testFalseIsNotWhitespace_AntX03", "NOT-NotWS; p.ws is whitespace");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseIsSet_AntX03()
    {
        runExpecting("testFalseIsSet_AntX03", "NOT-isset; p.not.defined undefined");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseIsNotSet_AntX03()
    {
        runExpecting("testFalseIsNotSet_AntX03", "NOT-isnotset; p.true exists");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseIsNumeric_AntX03()
    {
        runExpecting("testFalseIsNumeric_AntX03", "NOT-isnumeric; p.false not number");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseIsNumericUndefinedProperty_AntX03()
    {
        runExpecting("testFalseIsNumeric2_AntX03", "NOT-isnumeric; p.not.defined undefined");
    }

    /** @since JWare/AntX 0.3 **/
    public void testFalseAnySet_AntX03()
    {
        runExpecting("testFalseAnySet_AntX03", "NOT-anyset; p.not.defined undefined");
    }

    /** @since JWare/AntX 0.4 **/
    public void testFalseAntVersionIs_AntX04()
    {
        runExpecting("testFalseAntVersionIs_AntX04", "NOT-ant 1.1");
    }

    /** @since JWare/AntX 0.4 **/
    public void testFalseAntVersionLike_AntX04()
    {
        runExpecting("testFalseAntVersionLike_AntX04", "NOT-ant like 'HumptyDumpty'");
    }

    /** @since JWare/AntX 0.5 **/
    public void testFalseIsNotRef_AntX05()
    {
        runExpecting("testFalseIsNotRef_AntX05","NOT-isnotref: ant.PropertyHelper");
    }
}


/* end-of-VerifyFixtureTest.java */
