/**
 * $Id: MsgTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.starters.MsgTask;

/**
 * Class test for {@linkplain com.idaremedia.antx.starters.MsgTask MsgTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class MsgTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new MsgTaskTest testcase.
     **/
    public MsgTaskTest(String methodName)
    {
        super("MsgTask::",methodName);
    }


    /**
     * Create full test suite for MsgTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(MsgTaskTest.class);
    }


    /**
     * Create baseline test suite for MsgTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(MsgTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("msgid.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testEmptyElement()
    {
        expectLog("testEmptyElement","");
    }

    public void testEmptyMsgId()
    {
        expectLog("testEmptyMsgId","");
    }

    public void testEmptyMsgIdWithDefaultMsg()
    {
        expectLog("testEmptyMsgIdWithDefaultMsg","Helloworld");
    }

    public void testNoMsgIdWithDefaultMsg()
    {
        expectLog("testNoMsgIdWithDefaultMsg","Hellopeoples");
    }

    /** Verify 'message' parameter used if can't find 'msgid'.
     *  @since JWare/AntX 0.4
     **/
    public void testMissingIdWithMessage_AntX04()
    {
        expectLog("testMissingIdWithMessage_AntX04",
                  "The Fall Back Inlined Message");
    }


    /** Verify nested &lt;defaultmsg&gt; used if can't find 'msgid'.
     *  @since JWare/AntX 0.4
     **/
    public void testMissingIdWithDefaultMsg_AntX04()
    {
        expectLog("testMissingIdWithDefaultMsg_AntX04",
                  "The Nested Fall Back Message");
    }

    public void testDefaultNoiseLevel()
    {
        MsgTask t= new MsgTask();
        assertIdent(t.getDefaultMsgLevel(),
                    NoiseLevel.INFO,"default.noiselevel");
        expectLog("testDefaultNoiseLevel","");
    }

    public void testLowNoiseLevel()
    {
        expectFullLogContaining("testDebugNoiseLevel","DebugHello");
    }

    public void testLegitMsgIdFound()
    {
        expectLogContaining("testLegitMsgIdFound",
                            InitUISMTaskTest.DBG_MSG_OTHER_UISTRINGS);
        println("LOG: ",getLog());
    }

    /** Verify 'message' not used if *can* find 'msgid'.
     *  @since JWare/AntX 0.4
     **/
    public void testLegitIdWithMessage_AntX04()
    {
        String log = runTarget("testLegitIdWithMessage_AntX04");
        println("LOG: ",getLog());
        verifyOccurances(log,InitUISMTaskTest.DBG_MSG_OTHER_UISTRINGS,1);
        verifyOccurances(log,"ERROR YOU SHOULD NOT BE HERE",0);
    }

    public void testMsgArgSubstitution()
    {
        String log = runTarget("testArgSubstitution");
        verifyOccurances(log,"Mulder",1);
        verifyOccurances(log,"Sculley",1);
        verifyOccurances(log,"Seekrits",2);
    }

    public void testEchoLikeParameters()
    {
        expectLog("testEchoLikeParameters","JustLikeTheEchoTask");
    }

    /** @since JWare/AntX 0.3 **/
    public void testPropertyMsgIdsUsed_AntX03()
    {
        String log = runTarget("testPropertyMsgIdsUsed_AntX03");
        verifyOccurances(log,"Whups! echo_",1);
        verifyOccurances(log,"|||!",1);
        verifyOccurances(log,"booboo.msgid",1);//the one -before- allowing
    }
}

/* end-of-MsgTaskTest.java */
