/**
 * $Id: ItemList.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  java.util.Iterator;

import org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.helpers.InnerString;
import  com.idaremedia.antx.starters.ListFriendly;
import  com.idaremedia.antx.starters.StringItemList;

/**
 * A formal (type-safe) list of strings for testing purposes.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple (after fully configured)
 * @.group   test,helper
 **/

public final class ItemList extends StringItemList implements ListFriendly
{
    /**
     * Initializes a new ItemList instance.
     **/
    public ItemList()
    {
        super(AntX.nopackage);
    }


    /**
     * Appends given string (with property substitution) to
     * this string list.
     * @param string new string
     **/
    public void addConfiguredString(InnerString string)
    {
        require_(string!=null,"addStr- nonzro itm");
        addItem(string,getProject());
    }


    /**
     * Returns a comma-delimited list of this list's contents.
     **/
    public String stringFrom(Project theProject)
    {
        if (isReference()) {
            return getOtherList().stringFrom(theProject);
        }
        StringBuffer sb = new StringBuffer(100);
        int N=0;
        Iterator itr= readonlyStringIterator(theProject);
        while (itr.hasNext()) {
            if (N>0) {
                sb.append(",");
            }
            sb.append(itr.next());
            N++;
        }
        itr=null;
        return sb.substring(0);
    }


    public String toString()
    {
        return stringFrom(getProject());
    }


    private final ItemList getOtherList()
    {
        return (ItemList)getOtherItemList(ItemList.class);
    }
}

/* end-of-ItemList.java */
