/**
 * $Id: AssertLoggedTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.condition.logs.AssertLoggedTask
 * AssertLoggedTask} and {@linkplain com.idaremedia.antx.condition.logs.CaptureLogsTask
 * CaptureLogsTask}.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class AssertLoggedTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new AssertLoggedTaskTest testcase.
     **/
    public AssertLoggedTaskTest(String methodName)
    {
        super("AssertLoggedTask::",methodName);
    }


    /**
     * Create full test suite for AssertTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(AssertLoggedTaskTest.class);
    }


    /**
     * Create baseline test suite for AssertTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        super.setUp();
        configureProjectFromResource("assertlog.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testEmptyLogRecorderWorks()
    {
        runTarget("testEmptyLogsRecorder");
    }

    public void testBrokenMixtureOfValueAndNestedStrings()
    {
        runExpecting("testBrokenMixtureOfValueAndNestedStrings",
                     "Can't have mixture of 'value' and 'string' elements");
    }

    public void testNeedAtLeastValueOrNestedString()
    {
        runExpecting("testNeedAtLeastValueOrNestedString",
                     "Need value or nested 'string'");
    }

    public void testFalseCheckThrowsException()
    {
        runExpecting("testFalseTest_1","String 'ickyblorf' not in log");
        runExpecting("testFalseTest_2","String '(fubar)))' not in log");
        runExpecting("testFalseTest_3","String '((fubar))' not in important logs");
        runExpecting("testFalseTest_4","Log isn't rewound to look for each string");
    }

    public void testCaptureDefaultLevels()
    {
        runTarget("testCaptureDefaultLevels");
    }

    /** @since JWare/AntX 0.4 **/
    public void testCaptureDefaultLevelsStdio_AntX03()
    {
        runTarget("testCaptureDefaultLevelsStdio_AntX03");
    }

    public void testDifferentiateImportantUnimportant()
    {
        runTarget("testDifferentiateImportantUnimportant");
    }

    public void testClearingLogs()
    {
        runTarget("testClearingLogs");
    }

    public void testPassOrderedNestedItems()
    {
        runTarget("testFindOrderedItems");
    }

    public void testNestedCapturedLogs()
    {
        runTarget("testNestedCaptureLogs");
    }

    /** @since JWare/AntX 0.3 **/
    public void testCopyingCapturedLogs_AntX03()
    {
        runTarget("testCopyingCapturedLogs");
    }

    /** @since JWare/AntX 0.3 **/
    public void testMatchRegularExpressions_AntX03()
    {
        runTarget("testMatchingREs");
    }
    
    /** @since JWare/AntX 0.5 **/
    public void testCopyToFileByURL_AntX05()
    {
        runTarget("testCopyToFileByURL_AntX05");
    }
}


/* end-of-AssertLoggedTaskTest.java */
