/**
 * $Id: AllTests.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Super-suite for all <i>JWare/AntX</i> core unit tests/suites.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class AllTests extends TestSuite
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="PACKAGE_AGGREGATE";


    /**
     * Creates a suite of all <i>JWare/AntX</i> core class tests.
     **/
    public AllTests()
    {
        super();
        setName("Super-TestSuite for: "+FQPN);
        this.addTest(IterationTest.suite());
        this.addTest(UtilitiesTest.suite());
        this.addTest(InitUISMTaskTest.suite());
        this.addTest(UISMConfigureTaskTest.suite());

        this.addTest(MsgTaskTest.suite());
        this.addTest(ExportTaskTest.suite());
        this.addTest(CopyMsgTaskTest.suite());
        this.addTest(EchoErrorTaskTest.suite());
        this.addTest(EchoItemsTaskTest.suite());

        this.addTest(VerifyFixtureTest.suite());
        this.addTest(AssertionRuleTest.suite());
        this.addTest(PreferRuleTest.suite());
        this.addTest(BuildRuleTest.suite());
        this.addTest(TallyTaskTest.suite());
        this.addTest(AssertLoggedTaskTest.suite());
        
        this.addTest(ManagerTaskTest.suite());
    }


    /**
     * Creates a suite of all <i>JWare/AntX</i> core class tests.
     **/
    public static TestSuite suite()
    {
        return new AllTests();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


    /** Fully qualified (home) package name. **/
    private static final String FQPN= "JWare.AntX.core";
}

/* end-of-AllTests.java */
