/**
 * $Id: StringListTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003,2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.solo.tests;

import  java.util.ArrayList;
import  java.util.Iterator;

import  junit.framework.TestSuite;
import  org.apache.tools.ant.BuildException;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

import  com.idaremedia.antx.helpers.InnerString;
import  com.idaremedia.antx.ownhelpers.LocalTk;
import  com.idaremedia.antx.solo.StringList;

/**
 * Class test for {@linkplain com.idaremedia.antx.solo.StringList StringList}.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003,2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class StringListTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new StringListTest testcase.
     **/
    public StringListTest(String methodName)
    {
        super("StringList::",methodName);
    }


    /**
     * Create full test suite for StringList.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(StringListTest.class);
    }


    /**
     * Create baseline test suite for StringList (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }

// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    final static String PFX="CALL(";
    final static String SFX=")";

    protected void setUp() throws Exception
    {
        configureProjectFromResource("lists.xml");
    }

    private void addABCStrings(StringList out)
    {
        InnerString i= new InnerString();
        i.setValue("a");
        out.addConfiguredString(i);
        i.setValue("b");
        out.addConfiguredString(i);
        i.setValue("c");
        out.addConfiguredString(i);
        assertFalse(out.isEmpty());
    }

    private void verifyABCStrings(StringList out, Iterator itr, String who)
    {
        assertNotNil(itr);
        ArrayList sl= new ArrayList();
        while (itr.hasNext()) {
            sl.add(itr.next());
            try {itr.remove();} catch(UnsupportedOperationException igx) {}
        }
        assertEqual(sl.size(),3);
        assertEqual(sl.get(0),"a",who+".item@1");
        assertEqual(sl.get(1),"b",who+".item@2");
        assertEqual(sl.get(2),"c",who+".item@3");
        assertEqual(out.toString(),"a,b,c");//NB:ensure itr didn't zap
    }

    private void verifyABCStrings(StringList out, String who)
    {
        verifyABCStrings(out,out.readonlyIterator(),who);
        verifyABCStrings(out,out.readonlyStringIterator(),who);
    }

    private void verifyABCStrings(StringList out, Iterator itr,
                                  String pfx, String sfx,String who)
    {
        assertNotNil(itr);
        ArrayList sl= new ArrayList();
        while (itr.hasNext()) {
            sl.add(itr.next());
            try {itr.remove();} catch(UnsupportedOperationException igx) {}
        }
        assertEqual(sl.size(),3);
        assertEqual(sl.get(0),pfx+"a"+sfx,who+".item@1");
        assertEqual(sl.get(1),pfx+"b"+sfx,who+".item@2");
        assertEqual(sl.get(2),pfx+"c"+sfx,who+".item@3");
        String X= pfx+"a"+sfx+","+pfx+"b"+sfx+","+pfx+"c"+sfx;
        assertEqual(out.toString(),X);//NB:ensure itr didn't zap
    }

    private void verifyABCStrings(StringList out, String pfx, String sfx,String who)
    {
        verifyABCStrings(out,out.readonlyIterator(),pfx,sfx,who);
        verifyABCStrings(out,out.readonlyStringIterator(),pfx,sfx,who);
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    /** @since JWare/AntX 0.3 **/
    public void testEmptyStringListOK_AntX03()
    {
        runTarget("testEmptyStringListOK_AntX03");
    }

    /** @since JWare/AntX 0.3 **/
    public void testConstructor_AntX03()
    {
        StringList out = new StringList("a,b,c");
        verifyABCStrings(out,"ctor(orig)");
        StringList copy = (StringList)out.clone();
        verifyABCStrings(copy,"ctor(copy)");
    }

    /** @since JWare/AntX 0.3 **/
    public void testAddingStrings_AntX03()
    {
        StringList out = new StringList();
        assertTrue(out.isEmpty());
        addABCStrings(out);
        verifyABCStrings(out,"add(orig)");
        StringList copy = (StringList)out.clone();
        verifyABCStrings(copy,"add(copy)");
    }

    /** @since JWare/AntX 0.3 **/
    public void testPrefixSuffix_AntX03()
    {
        StringList out = new StringList();
        out.setPrefix(PFX);
        out.setSuffix(SFX);
        addABCStrings(out);
        verifyABCStrings(out,PFX,SFX,"pfxsfx(orig.a)");
        StringList copy = (StringList)out.clone();
        verifyABCStrings(copy,PFX,SFX,"pfxsfx(copy.a)");
        copy.setPrefix("BLABLABLA");
        verifyABCStrings(out,PFX,SFX,"pfxsfx(orig.b)");
        verifyABCStrings(copy,"BLABLABLA",SFX,"pfxsfx(copy.b)");
    }

    /** @since JWare/AntX 0.3 **/
    public void testStringListDelim_AntX03()
    {
        runTarget("testStringListDelim_AntX03");
    }


    /** @since JWare/AntX 0.3 **/
    public void testStringListReferences_AntX03()
    {
        runTarget("testStringListReferences_AntX03");

        //Try some stuff here but the JUnit+Ant ClassLoader mess
        // prevents any meaningful tests w/ references(ssmc)
        Object o = getProject().getReference("abcstrings");
        assertNotNil(o);
        StringList out = new StringList();
        out.setRefid(LocalTk.referenceFor("abcstrings",getProject()));
        assertTrue(out.isReference());
        try { out.setPrefix("phffht"); }
        catch(BuildException bx) {/*burp*/}
        try { out.setSuffix("phffht"); }
        catch(BuildException bx) {/*burp*/}
    }


    /* @since JWare/AntX 0.4 **/
    public void testStringListFromFiles_AntX04()
    {
        runTarget("testStringListFromFiles_AntX04");
    }
    
    
    /* @since JWare/AntX 0.5 */
    public void testIncludeOtherStringList_AntX05()
    {
        runTarget("testIncludeOtherStringList_AntX05");
    }
}


/* end-of-StringListTest.java */
