/**
 * $Id: PropertiesListTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.solo.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;


/**
 * Testsuite for {@linkplain com.idaremedia.antx.solo.PropertiesList PropertiesList}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test,
 * @see       com.idaremedia.antx.solo.PropertiesList
 **/

public final class PropertiesListTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new PropertiesListTest testcase.
     **/
    public PropertiesListTest(String methodName)
    {
        super("PropertiesList::",methodName);
    }


    /**
     * Create full test suite for PropertiesList.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(PropertiesListTest.class);
    }


    /**
     * Create baseline test suite for PropertiesList (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }

// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("lists.xml");
    }

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testIncludeOtherPropertiesList_AntX05()
    {
        runTarget("testIncludeOtherPropertiesList_AntX05");
    }
    
    public void testOptionalPropertiesListIncludeWorks_AntX05()
    {
        runTarget("testOptionalPropertiesListIncludeWorks_AntX05");
    }
    
    public void testCanReferToOtherPropertiesLikeTypes_AntX05()
    {
        runTarget("testCanReferToOtherPropertiesLikeTypes_AntX05");
    }
}

/* end-of-PropertiesListTest.java */