/**
 * $Id: MappingPrinter.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.print;

import  java.io.IOException;
import  java.io.OutputStream;
import  java.io.PrintStream;
import  java.util.Date;
import  java.util.Iterator;


/**
 * Default strategy for printing a {@linkplain PrinterMapping} to an output stream.
 * Prints a series of "<i>key=value</i>" for the display class name and for each
 * mapping pair. For example the mapping: <pre>
 *   &lt;printer classname="my.foo.Printer" forclass="my.bar.Class"/&gt;
 * </pre>
 * will produce output like:<pre>
 *    CLASSNAME=my.foo.Printer
 *    &#64;1=my.bar.Class
 * </pre>
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 * @see      PrinterMapping
 **/

public final class MappingPrinter implements DisplayStrategy
{
    /**
     * Initializes a new MappingPrinter.
     **/
    public MappingPrinter()
    {
    }


    /**
     * Writes the display strategy's full class name with key
     * "CLASSNAME", then copies the set of mapped-to class names
     * to the given output stream. The generated output can be
     * fed back into a printer mapping as a resource.
     * @param info display information (non-null)
     * @param os the output stream (non-null)
     * @throws IOException if any I/O error occurs
     **/
    public void print(final DisplayRequest info, OutputStream os)
        throws IOException
    {
        Object thing = info.getObjectToBeDisplayed();

        if (thing instanceof PrinterMapping) {
            PrinterMapping pm = (PrinterMapping)thing;
            PrintStream ps = new PrintStream(os);

            //- header
            ps.println();
            ps.print("#PrinterMapping: ");
            ps.println(pm.getId());
            ps.print("#");
            ps.println(new Date());
            ps.print("#Size: ");
            ps.println(String.valueOf(pm.getTargetClasses().size()));

            //- content
            ps.print(PrinterMapping.RESOURCE_KEY);
            ps.print("=");
            ps.println(String.valueOf(pm.getPrinterClassName()));
            Iterator itr= pm.getTargetClasses().iterator();
            int i=1;
            while (itr.hasNext()) {
                ps.print("@");
                ps.print(i++);
                ps.print("=");
                ps.println(((Class)itr.next()).getName());
            }
            try {os.flush();} catch(IOException iox) {/*burp*/}
            itr = null;
            ps = null;
        }
    }
}

/* end-of-MappingPrinter.java */
