/**
 * $Id: DiagnosticsValue.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.print;

import  java.io.ByteArrayOutputStream;
import  java.io.IOException;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.FlexString;
import  com.idaremedia.antx.Stringifier;
import  com.idaremedia.antx.helpers.Tk;


/**
 * Special subclass of a FlexString that can use a {@linkplain PrinterRegistry}
 * to handle project reference data (er) references. A lenient diagnostics value will
 * always fallback to <span class="src">String.valueOf(...)</span> if it encounters
 * any problems.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 * @see      com.idaremedia.antx.feedback.EmitInclude EmitInclude
 **/

public final class DiagnosticsValue extends FlexString
{
    /**
     * Create a new strict diagnostics value.
     **/
    public DiagnosticsValue()
    {
        super();
    }


    /**
     * Create a new optionally lenient diagnostics value.
     * @param lenient <i>true</i> to make lenient
     **/
    public DiagnosticsValue(boolean lenient)
    {
        super();
        setLenient(lenient);
    }


    /**
     * Figure out what to do with generic reference types.
     * Never returns <i>null</i> (can return the string "null").
     * @throws BuildException if printer throws one
     **/
    protected String stringFrom(Object o, Project P)
    {
        String s = Stringifier.get(false).stringFrom(o,P);
        if (s==null) {
            PrinterRegistry registry = PrinterRegistryContext.getPrinterRegistryNoNull();
            if (registry==PrinterRegistryContext.getEmptyPrinterRegistry()) {
                s = Tk.stringFrom(o,P);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream(100);
                DisplayRequest r = new DisplayRequest(o);
                try {
                    registry.getPrinterForNoNull(o).print(r,os);
                } catch (IOException iox) {
                    if (!isLenient()) {
                        throw new BuildException(iox);
                    }
                    iox.printStackTrace(System.err);//NB:careful-4 loopback
                    return Tk.stringFrom(o,P);
                }
                r = null;
                s = os.toString();
                os = null;
            }
        }
        return s;
    }
}

/* end-of-DiagnosticsValue.java */
