/**
 * $Id: PlatformConditional.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.parameters;

/**
 * A component that is only valid if certain platform-dependent criteria are met.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 **/

public interface PlatformConditional
{
    /**
     * Adds an if-os-matches condition to this component.
     * The supplied string can contain a comma-delimited
     * selection list in the form: <i>family,name,arch,version</i>.
     * To omit an field, put a "<span class="src">*</span>"
     * in that location like: "<span class="src">*,Linux,i686,*</span>".
     * If the field is at the end of the list, you can just
     * omit the field altogether like:
     * "<span class="src">unix,Linux</span>".
     * @param choice os selection string (non-null)
     **/
    void setIfOS(String choice);


    /**
     * Adds an unless-os-matches condition to this component.
     * See {@linkplain #setIfOS setIfOS(&#8230;)} for a
     * description of the <span class="src">choice</span>
     * string's format.
     * @param choice os selection string (non-null)
     **/
    void setUnlessOS(String choice);


    /**
     * Adds an if-ant-version-matches condition to this
     * component. The value returned by the Ant runtime's
     * "<span class="src">ant.version</span>" property
     * is what's tested.
     * @param versionRE regular expression for version
     **/
    void setIfAntLike(String versionRE);


    /**
     * Adds an unless-ant-version-matches condition to this
     * component. The value returned by the Ant runtime's
     * "<span class="src">ant.version</span>" property is
     * what's tested.
     * @param versionRE regular expression for version
     **/
    void setUnlessAntLike(String versionRE);
}

/* end-of-PlatformConditional.java */
