/**
 * $Id: IsA.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.parameters;

import  com.idaremedia.antx.helpers.Tk;

/**
 * Enumeration of a flex value's possible interpretation: as a literal, as a property,
 * as a reference, or as a variable (exported property).
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 **/

public final class IsA extends EnumSkeleton
{
    /** Index of {@linkplain #LITERAL LITERAL}. **/
    public static final int LITERAL_INDEX= 0;
    /** Index of {@linkplain #PROPERTY PROPERTY}. **/
    public static final int PROPERTY_INDEX= LITERAL_INDEX+1;
    /** Index of {@linkplain #VARIABLE VARIABLE}. **/
    public static final int VARIABLE_INDEX= PROPERTY_INDEX+1;
    /** Index of {@linkplain #REFERENCE REFERENCE}. **/
    public static final int REFERENCE_INDEX= VARIABLE_INDEX+1;

    /** Singleton "literal" Is-A. **/
    public static final IsA LITERAL = new IsA("literal",LITERAL_INDEX);
    /** Singleton "property" Is-A. **/
    public static final IsA PROPERTY = new IsA("property",PROPERTY_INDEX);
    /** Singleton "variable" Is-A. **/
    public static final IsA VARIABLE = new IsA("variable",VARIABLE_INDEX);
    /** Singleton "reference" Is-A. **/
    public static final IsA REFERENCE = new IsA("reference",REFERENCE_INDEX);


    /**
     * Required bean void constructor for Ant's introspector.
     **/
    public IsA()
    {
        super();
    }


    /**
     * Use to create public singletons. Ensure it's initialized
     * as with default Ant Introspector helper thingy.
     **/
    private IsA(String v, int i)
    {
        super(v);
    }


    /**
     * Returns copy of all possible modification values as an ordered
     * string array. Note: ordering should be same as singletons indice.
     **/
    public String[] getValues()
    {
        return new String[] {"literal","property","variable","reference"};
    };



    /**
     * Helper that converts a scalar to a known IsA. Returns <i>null</i>
     * if value does not match any of expected modifications.
     * @param i the index to be matched
     **/
    public static IsA from(int i)
    {
        if (i==PROPERTY.index)  { return PROPERTY; }
        if (i==VARIABLE.index)  { return VARIABLE; }
        if (i==REFERENCE.index) { return REFERENCE; }
        if (i==LITERAL.index)   { return LITERAL; }
        return null;
    }


    /**
     * Same as {@linkplain #from(int) from(int)} but with a
     * default value if value does not match any known IsA's
     * index.
     * @param i the index to be matched
     * @param dflt the default IsA if necessary
     **/
    public static IsA from(int i, IsA dflt)
    {
        IsA isa= from(i);
        return (isa==null) ? dflt : isa;
    }


    /**
     * Helper that converts a string to a known IsA singleton.
     * Returns <i>null</i> if string unrecognized. String can be
     * either IsA's symbolic name or its index.
     **/
    public static IsA from(String s)
    {
        if (s!=null && s.length()>1) {
            s = Tk.lowercaseFrom(s);
            if (Character.isDigit(s.charAt(0))) {
                try { return from(Integer.parseInt(s)); }
                catch(Exception nfx) {/*burp*/}
            } else {
                if ("prop".equals(s))          { return PROPERTY; }
                if (PROPERTY.value.equals(s))  { return PROPERTY; }
                if ("var".equals(s))           { return VARIABLE; }
                if (VARIABLE.value.equals(s))  { return VARIABLE; }
                if ("ref".equals(s))           { return REFERENCE;}
                if (REFERENCE.value.equals(s)) { return REFERENCE;}
                if ("value".equals(s))         { return LITERAL;  }
                if (LITERAL.value.equals(s))   { return LITERAL;  }

                if ("variables".equals(s))     { return VARIABLE; }
                if ("references".equals(s))    { return REFERENCE;}
                if ("properties".equals(s))    { return PROPERTY; }
                if ("default".equals(s))       { return PROPERTY; }
            }
        }
        return null;
    }


    /**
     * Same as {@linkplain #from(java.lang.String) from(String)} but
     * with a default value if value does not match any known
     * IsA's name.
     * @param s the symbolic name to be matched
     * @param dflt the default IsA if necessary
     **/
    public static IsA from(String s, IsA dflt)
    {
        IsA isa= from(s);
        return (isa==null) ? dflt : isa;
    }
}

/* end-of-IsA.java */
