/**
 * $Id: FlexConditional.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.parameters;

/**
 * A component that supports an extended set of if/unless conditions to determine
 * whether it executes. A flex condition's execution is determined by the combination
 * of <em>all</em> of its <i>if*</i> and <i>unless*</i> condiitons.
 * <p>
 * <b>Examples:</b><pre>
 *    &lt;do ifAll="ant.file,ant.version"&gt;&#8230;
 *    &lt;do unlessAnt="^.*version 1\.5\.[3-9]?.*"&gt;&#8230;
 *    &lt;call ifOS="unix" &#8230;&gt;
 *    &lt;foreach ifAllTrue="javac.debug,javadoc.debug"&gt;&#8230;
 * </pre>
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 **/

public interface FlexConditional extends Conditional, PlatformConditional
{
    /**
     * Adds a positive boolean condition to this component.
     * The condition is <i>true</i> if the incoming string 
     * represents a positive boolean string like <span class="src">yes</span>.
     * This method allows conditional tasks to leverage AntX value
     * URIs that generate a boolean string. 
     * @param booleanString the string to evaluate
     * @since JWare/AntX 0.5
     */
    void setTrue(String booleanString);


    /**
     * Adds a negative boolean condition to this component.
     * The condition is <i>true</i> if the incoming string 
     * represents a negative boolean string like <span class="src">no</span>.
     * This method allows conditional tasks to leverage AntX value
     * URIs that generate a boolean string. 
     * @param booleanString the string to evaluate
     * @since JWare/AntX 0.5
     **/
    void setFalse(String booleanString);


    /**
     * Adds an if-true condition to this component. The
     * condition is only <i>true</i> if the named property
     * is defined as one of the positive Ant boolean
     * strings (like "<span class="src">yes</span>" or
     * "<span class="src">true</span>").
     * @see #setIfAllTrue setIfAllTrue
     **/
    void setIfTrue(String property);


    /**
     * Adds an unless-true condition to this component. The
     * condition is only <i>true</i> if the named property
     * does not exist or is not defined as one of the
     * positive Ant boolean strings (like
     * "<span class="src">yes</span>" or
     * "<span class="src">true</span>").
     * @see #setUnlessAllTrue setUnlessAllTrue
     **/
    void setUnlessTrue(String property);


    /**
     * Adds an if-all condition to this component. The
     * condition is only <i>true</i> if all of the named
     * properties exist.
     * @param properties comma-delimited list of property names
     **/
    void setIfAll(String properties);


    /**
     * Adds an unless-all condition to this component. The
     * condition is only <i>true</i> if none of the named
     * properties exist.
     * @param properties comma-delimited list of property names
     **/
    void setUnlessAll(String properties);


    /**
     * Adds an if-all-true condition to this component. The
     * condition is only <i>true</i> if all of the named
     * properties exist and are defined as valid positive Ant
     * boolean strings.
     * @param properties comma-delimited list of property names
     * @see #setIfTrue setIfTrue
     **/
    void setIfAllTrue(String properties);


    /**
     * Adds an unless-all-true condition to this component. The
     * condition is only <i>true</i> if none of the named
     * properties exist, or if none are defined to a positive
     * Ant boolean string.
     * @param properties comma-delimited list of property names
     * @see #setUnlessTrue setUnlessTrue
     **/
    void setUnlessAllTrue(String properties);


    /**
     * Returns <i>true</i> if all of this component's
     * current <i>if</i> conditions are <i>true</i>.
     **/
    boolean testIfCondition();


    /**
     * Returns <i>true</i> if all of this component's
     * current <i>unless</i> conditions are <i>true</i>.
     **/
    boolean testUnlessCondition();
}


/* end-of-FlexConditional.java */
