/**
 * $Id: ProjectDependentSkeleton.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ownhelpers;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.apis.ProjectDependent;

/**
 * Starting point for a simple AntX utility or helper that depends on a project
 * to perform its function.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 **/

public abstract class ProjectDependentSkeleton implements ProjectDependent
{
    /**
     * Initializes this project dependent object.
     **/
    protected ProjectDependentSkeleton()
    {
    }


    /**
     * (Re)initialize this dependent target project.
     * @param P the project
     **/
    public void setProject(Project P)
    {
        m_P = P;
    }



    /**
     * Returns this object's targeted project. Can return
     * <i>null</i> if this attribute never defined.
     **/
    public Project getProject()
    {
        return m_P;
    }


    /**
     * Returns this object's targeted project ensuring the
     * reference is not <i>null</i>. Calls {@linkplain #getProject}.
     * @throws IllegatStateException if project is <i>null</i>.
     **/
    protected final Project getProjectNoNull()
    {
        Project P= getProject();
        AntX.verify_(P!=null,AntX.AntX+"ProjectDependent:","getProj- inited");
        return P;
    }



    /**
     * Logs given message to our project if project exists.
     * Otherwise, writes message to stdout.
     * @param message the message (non-null)
     * @since JWare/AntX 0.5
     **/
    protected void log(String message)
    {
        Project P = getProject();
        if (P!=null) {
            P.log(message);
        } else {
            System.out.println(message);
        }
    }



    /**
     * Logs given message at named level to our project if 
     * project exists. Otherwise, writes message to stdout
     * or stderr.
     * @param message the message (non-null)
     * @param msgLevel message noise level
     * @since JWare/AntX 0.5
     **/
    protected void log(String message, int msgLevel)
    {
        Project P = getProject();
        if (P!=null) {
            P.log(message,msgLevel);
        } else {
            if (msgLevel==Project.MSG_WARN || msgLevel==Project.MSG_ERR) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }
    }



    private Project m_P;
}

/* end-of-ProjectDependentSkeleton.java */
