/**
 * $Id: ConditionalInnerNameValuePair.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ownhelpers;

import  com.idaremedia.antx.helpers.InnerNameValuePair;
import  com.idaremedia.antx.parameters.Conditional;

/**
 * Simple key-value parameter helper that supports optional inclusion using standard
 * if/unless mechanism.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,helper
 **/

public class ConditionalInnerNameValuePair extends InnerNameValuePair
    implements Conditional
{
    /**
     * Initializes a new inner name/value pair.
     **/
    public ConditionalInnerNameValuePair()
    {
        super();
    }



    /**
     * Creates new predefined pair.
     **/
    public ConditionalInnerNameValuePair(String name, String value)
    {
        super(name,value);
    }



    /**
     * Sets this parameter's 'if' constraint.
     * @param property name of guard property (non-null)
     **/
    public void setIf(String property)
    {
        m_ifProperty = property;
    }

    /**
     * Returns this parameter's 'if' constraint or <i>null</i> 
     * if none set explicitly.
     **/
    public String getIfProperty()
    {
        return m_ifProperty;
    }


    /**
     * Sets this parameter's 'unless' constraint.
     * @param property name of guard property (non-null)
     **/
    public void setUnless(String property)
    {
        m_unProperty = property;
    }


    /**
     * Returns this parameter's 'unless' constraint or <i>null</i> 
     * if none set explicitly.
     **/
    public String getUnlessProperty()
    {
        return m_unProperty;
    }


    private String m_ifProperty, m_unProperty;
}

/* end-of-ConditionalInnerNameValuePair.java */