/**
 * $Id: MkTempTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.mktemp.tests;

import  java.io.File;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

import  com.idaremedia.antx.mktemp.TempLocator;
import  com.idaremedia.antx.mktemp.MkTempDirectory;
import  com.idaremedia.antx.mktemp.MkTempFile;

/**
 * Class tests for {@linkplain com.idaremedia.antx.mktemp.TempLocator TempLocator}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class MkTempTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new MkTempTest testcase.
     **/
    public MkTempTest(String methodName)
    {
        super("MkTemp::",methodName);
    }


    /**
     * Create full test suite for TempLocator.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(MkTempTest.class);
    }


    /**
     * Create baseline test suite for TempLocator (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(MkTempTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("mktemp.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
        File tmpdir = TempLocator.getSystemTempDir();
        assertNotNil(tmpdir);
        assertFalse(tmpdir.getName().indexOf("_will_die")>=0,"Invalid TMPDIR");
    }

    public void testEmptyTmpDirElement()
    {
        expectLog("testEmptyTmpDirElement","");
    }

    public void testJustSetTempDir()
    {
        runTarget("testJustSetTempDir");
    }

    public void testJustSetTempDirUrl_AntX05()
    {
        runTarget("testJustSetTempDirUrl_AntX05");
    }

    public void testCreatingOwnTempDirRoot()
    {
        runTarget("testOwnTempDirRoot");
    }

    public void testMkTempDirBasic()
    {
        runTarget("testMkTempDirBasic");
    }

    public void testMkTempFileBasic()
    {
        runTarget("testMkTempFileBasic");
    }

    public void testMkTempPrototypes()
    {
        runTarget("testMkTempPrototypes");
    }

    public void testFilteringPrototypes()
    {
        runTarget("testFilteringPrototypeFiles");
    }

    /** @since JWare/AntX 0.3 **/
    public void testMkTempFileByLine_AntX03()
    {
        runTarget("testMkTempFileByLine_AntX03");
    }

    /** @since JWare/AntX 0.4 **/
    public void testMkTempPropertiesFile_AntX04()
    {
        runTarget("testMkTempPropertiesFile_AntX04");
    }

    public void testMkTempFileDefaults()
    {
        MkTempFile out = new MkTempFile();
        out.setProject(getProject());
        assertNotNil(out.getEffectivePrefix(true));
        assertNotNil(out.getEffectiveSuffix(true));
        assertNotNil(out.getInDir());
        assertTrue(out.isAutoDelete());
        out.setPrefix("q");
        assertEqual(out.getPrefix(),"q");
        assertNotEqual(out.getEffectivePrefix(true),"q");
        assertTrue(out.getEffectivePrefix(true).length()>=0,"Prefix is at least 3chars");
        out.setPrefix("");
        assertEqual(out.getEffectivePrefix(true),"___");

        out = null;
        out = new MkTempFile();
        assertEqual(out.getEffectivePrefix(true),"qat");//different from empty pfx
        assertEqual(out.getEffectiveSuffix(true),".tmp");
    }

    public void testMkTempDirectoryDefaults()
    {
        MkTempDirectory out = new MkTempDirectory();
        out.setProject(getProject());
        assertNotNil(out.getEffectivePrefix(false));
        assertNotNil(out.getEffectiveSuffix(false));
        assertNotNil(out.getInDir());
        assertFalse(out.isAutoDelete());
        assertEqual(out.getEffectivePrefix(false),"qat");//different from empty pfx
        assertEqual(out.getEffectiveSuffix(false),"");
    }

    public void testBadInDirCaught()
    {
        runExpecting("testBadInDirCaught","In-Dir must exist");
    }
}

/* end-of-MkTempTest.java */
