/**
 * $Id: UISMSource.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.init;

import  java.io.File;
import  java.net.URL;

import  com.idaremedia.antx.parameters.FlexSourceSupport;

/**
 * Source of a raw PropertyResourceBundle used to define UIStringManagers.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 **/

public interface UISMSource extends FlexSourceSupport
{
    /**
     * Sets this source's resource bundle's location as a URL.
     * @param urlstr URL string representation (non-null)
     * @throws BuildException if this source is a reference or another
     *         or another bundle source has already been specified
     **/
    void setURL(String urlstr);


    /**
     * Returns this source's resource bundle's URL location. Returns
     * <i>null</i> if never set or was set to an invalid URL string.
     **/
    URL getURL();


    /**
     * Sets this source's resource bundle's location as a file.
     * @param filepath the readable file's path (non-null)
     * @throws BuildException if this source is a reference or another
     *         or another bundle source has already been specified
     **/
    void setFile(String filepath);


    /**
     * Returns this source's resource bundle's file location. Returns
     * <i>null</i> if never set (or determined from other source types).
     **/
    File getFile();


    /**
     * Sets this source's resource bundle's location as a classpath-based
     * resource name.
     **/
    void setResource(String rsrc);


    /**
     * Returns this source's resource bundle's classpath-based resource
     * name. Returns <i>null</i> if never set.
     **/
    String getResource();
}

/* end-of-UISMSource.java */
