/**
 * $Id: TaskHandle.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.helpers;

import  org.apache.tools.ant.Task;

/**
 * ResultObject wrapper for a Task reference.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 * @.pattern Fowler.ResultObject
 **/

public final class TaskHandle
{
    /**
     * Initializes an empty task handle.
     **/
    public TaskHandle()
    {
    }


    /**
     * Initializes a pre-filled task handle.
     **/
    public TaskHandle(Task t)
    {
        m_task = t;
    }


    /**
     * Returns this handle's underlying task. Can
     * return <i>null</i> if handle empty.
     **/
    public Task getTask()
    {
        return m_task;
    }



    /**
     * Updates this handle's underlying task.
     * @param t new task (can be <i>null</i>)
     **/
    public void setTask(Task t)
    {
        m_task = t;
    }


    /**
     * Clears this handle's underlying task.
     **/
    public void clrTask()
    {
        m_task = null;
    }


    /**
     * Returns <i>true</i> if this handle has no
     * underlying task.
     **/
    public boolean isEmpty()
    {
        return m_task==null;
    }


    /**
     * Returns this handle's underlying task's name
     * or empty string if no task.
     **/
    public String getTaskName()
    {
        return m_task==null ? "" : m_task.getTaskName();
    }



    private Task m_task;
}

/* end-of-TaskHandle.java */
