/**
 * $Id: NothingIterator.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 1997-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.helpers;

import  java.util.Enumeration;
import  java.util.NoSuchElementException;

/**
 * Iterator that iterates nothing&#150; <span class="src">hasNext()</span> is always
 * <i>false</i>. A NothingIterator instance can be used as an MT-safe singleton.
 *
 * @since    JWare/core 0.1
 * @author   ssmc, &copy;1997-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 **/

public class NothingIterator extends NoRemoveIteratorSkeleton
    implements Enumeration
{
    /**
     * VM/ClassLoader-shareable singleton.
     **/
    public static final NothingIterator INSTANCE= new NothingIterator();


    /**
     * Creates new nothing iterator object to iterate nothing.
     **/
    public NothingIterator()
    {
    }



    /**
     * Nothing to return; always throws a
     * <span class="src">NoSuchElementException</span> exception.
     **/
    public Object next()
    {
        throw new NoSuchElementException();
    }


    /**
     * Nothing to return; always throws a
     * <span class="src">NoSuchElementException</span> exception.
     **/
    public Object nextElement()
    {
        throw new NoSuchElementException();
    }


    /**
     * Nothing to return; always returns <i>false</i>.
     **/
    public boolean hasMoreElements()
    {
        return false;
    }


    /**
     * Nothing to return; always returns <i>false</i>.
     **/
    public boolean hasNext()
    {
        return false;
    }
}

/* end-of-NothingIterator.java */
