/**
 * $Id: Unless.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.go;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.helpers.Tk;

/**
 * Implementation of the general <i>unless</i> and <i>unlessTrue</i> tests for
 * all conditional components.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 **/

public final class Unless
{
    /**
     * Tests whether or not the given property name does not
     * resolve to a project property. Always returns <i>true</i>
     * for the <i>null</i> or empty string.
     * @param property the property name (non-null)
     * @param P the project to check against (non-null)
     * @return <i>true</i> if the property is <em>not</em> defined
     **/
    public static final boolean allowed(String property, Project P)
    {
        return allowed(property, P, false);
    }



    /**
     * Tests whether or not the given property name does not
     * resolve to a project property with a positive boolean
     * value. Always returns <i>true</i> for the <i>null</i>
     * or empty string.
     * @param property the property name (non-null)
     * @param P the project to check against (non-null)
     * @param onlyUnlessTrue <i>true</i> if property must be defined
     *        to a positive boolean string (like "yes")
     * @return <i>true</i> if the property is <em>not</em> defined
     *         or is not defined as to be positive boolean
     **/
    public static final boolean allowed(String property, Project P,
                                        boolean onlyUnlessTrue)
    {
        if (property==null || "".equals(property)) {
            return true;
        }
        String test = Tk.resolveString(P,property);
        if (onlyUnlessTrue) {
            return !Tk.booleanFrom(P.getProperty(test));//allow off,no,false
        }
        return P.getProperty(test)==null;
    }


    /** Don't allow **/
    private Unless()
    {
    }
}

/* end-of-Unless.java */
