/**
 * $Id: ConditionalLocal.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.wrap;

import  com.idaremedia.antx.helpers.InnerNameValuePair;
import  com.idaremedia.antx.helpers.Tk;

/**
 * A local parameter that can be conditionally applied.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,helper
 * @see       Locals
 **/

public final class ConditionalLocal extends InnerNameValuePair
{
    /**
     * Initializes a new conditional parameter.
     **/
    public ConditionalLocal()
    {
        setNull();
    }


    /**
     * Sets ths local's true condition evaluation <em>result</em>.
     * If the incoming string is a positive boolean string then
     * the "if condition" will pass.
     * @param boolstr the evaluation's result (non-null)
     **/
    public void setIf(String boolstr)
    {
        m_enabled = m_enabled && 
            Boolean.TRUE.equals(Tk.string2PosBool(boolstr));
    }



    /**
     * Sets ths local's false condition evaluation <em>result</em>.
     * If the incoming string is a positive boolean string then
     * the "unless condition" will fail.
     * @param boolstr the evaluation's result (non-null)
     **/
    public void setUnless(String boolstr)
    {
        m_enabled = m_enabled &&
            !Boolean.TRUE.equals(Tk.string2PosBool(boolstr));
    }



    /**
     * Returns <i>true</i> if this local's apply test(s) allow
     * installation.
     **/
    public final boolean isEnabled()
    {
        return m_enabled;
    }



    /**
     * Indicates whether this item should inherit its initial
     * value from the surrounding context. The default setting
     * of this property depends on the target fixture element.
     * @param inherit <i>true</i> to always inherit
     **/
    public void setInherit(boolean inherit)
    {
        m_inherit = inherit ? Boolean.TRUE : Boolean.FALSE;
    }



    /**
     * Returns this item's inherit flag setting. Will return
     * <i>null</i> if never set explicitly.
     **/
    public final Boolean getInheritFlag()
    {
        return m_inherit;
    }


    private boolean m_enabled = true;
    private Boolean m_inherit;
}

/* end-of-ConditionalLocal.java */