/**
 * $Id: StepCallerTestSkeleton.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) a later
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  com.idaremedia.antx.ut.HTC;

import  org.apache.tools.ant.Project;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.call.OnceTask OnceTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public abstract class StepCallerTestSkeleton extends HTC
{
    /**
     * Create new StepCallerTestSkeleton testcase.
     **/
    protected StepCallerTestSkeleton(String groupId, String methodName)
    {
        super(groupId,methodName);
    }

// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected abstract String getDefaultConfigureXMLFileName();

    protected void setUp() throws Exception
    {
        configureProjectFromResource(getDefaultConfigureXMLFileName());
        Project P= getProject();
        PS= P.getProperty("PS");
        AT= P.getProperty("at");
    }

    final int verifyTargetsRanInOrder(final String PFX, final int I, final int N, int ilastmatch)
    {
        String log= getLog();
        for (int i=I;i<=N;i++) {
            String match = PS+PFX+i+AT;
            int imatch = log.indexOf(match,ilastmatch);
            assertTrue("Expecting Log to contain \""+match+"\" from ["+ilastmatch+
                       "] but Log was \"" + log + "\"",
                       imatch>=0);
            ilastmatch = imatch;
        }
        return ilastmatch;
    }


    final int verifyTargetsInheritedParent(final int I, final int N, int ilastInheritedMatch)
    {
        String log= getLog();
        String inheritedMatch = PS+"mama"+AT;
        for (int i=I;i<=N;i++) {
            String localMatch = PS+"f"+i+AT;
            int iLocalMatch = log.indexOf(localMatch);
            int iInheritedMatch = log.indexOf(inheritedMatch, ilastInheritedMatch);
            assertTrue("Expecting Log to contain \""+inheritedMatch+"\" from ["+ilastInheritedMatch+
                       "] but Log was \"" + log + "\"",
                       iInheritedMatch>=0);
            assertTrue("Expecting Log not to contain \""+localMatch+"\" from [0"+
                       "] but Log was \"" + log + "\"",
                       iLocalMatch<0);
            ilastInheritedMatch = iInheritedMatch;
        }
        return ilastInheritedMatch;
    }

    final void verifyHaltedBeforeF2Run(String targetName, String T2)
    {
        require_(targetName!=null,"chkHalted- nonzro target");
        expectBuildException(targetName,
                             "HaltIfError on first broken step");
        assertPropertyEquals("abandoned.ship","yes");
        verifyOccurances(getLog(),T2,0);
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
        assertNotNil(PS,"PS");
        assertNotNil(AT,"at");
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    protected String PS,AT;
}

/* end-of-StepCallerTestSkeleton.java */
