/**
 * $Id: ForEachTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.call.ForEachTask
 * ForEachTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class ForEachTaskTest extends StepCallerTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new ForEachTaskTest testcase.
     **/
    public ForEachTaskTest(String methodName)
    {
        super("ForEachTask::",methodName);
    }


    /**
     * Creates a test suite with a single test.
     **/
    public static TestSuite suiteOfOne(String testName)
    {
        TestSuite s = new TestSuite();
        s.setName("Suite-of-One:"+testName);
        s.addTest(new ForEachTaskTest(testName));
        return s;
    }

    /**
     * Create full test suite for ProtectedTaskSet.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ForEachTaskTest.class);
//          return suiteOfOne("testItemListLoopControl_AntX03");
    }


    /**
     * Create baseline test suite for ProtectedTaskSet (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(ForEachTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "foreach.xml";
    }

    final int verifyTargetsRanInLoop(final String PFX, final int I, final int N, int ilastmatch)
    {
        String log= getLog();
        for (int i=I;i<N;i++) {
            String match = PS+PFX+AT+i;
            int imatch = log.indexOf(match,ilastmatch);
            assertTrue("Expecting Log to contain \""+match+"\" from ["+ilastmatch+
                       "] but Log was \"" + log + "\"",
                       imatch>=0);
            ilastmatch = imatch;
        }
        return ilastmatch;
    }

    final int verifyTargetsRanInLoop(String[] cursors, int ilastmatch)
    {
        String log= getLog();
        String match;
        int imatch;
        for (int i=0;i<cursors.length;i++) {
            match = "(at:"+cursors[i]+")";
            imatch = log.indexOf(match,ilastmatch);
            assertTrue("Expecting Log to contain \""+match+"\" from ["+ilastmatch+
                       "] but Log was \"" + log + "\"",
                       imatch>=0);
            ilastmatch = imatch+match.length();
        }
        return ilastmatch;
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void testFailEmptyForEachElement()
    {
        String log = runTarget("testFailEmptyElement");
        assertTrue(log.indexOf("phffht: it barfed")>=0,"It barfed");
    }

    public void testFailBrokenLoopDefinitions()
    {
        runTarget("testBrokenLoops");
    }

    public void testCantNestNonPropertiesInForEach()
    {
        verifyCantLoadFile("broken_foreach0.xml", "Invalid nested tasks");
    }

    public void testInLoopControl()
    {
        runTarget("testInLoopControl");
        int from=0;
        from= verifyTargetsRanInLoop(new String[]{"0"},from);
        from= verifyTargetsRanInLoop(new String[]{"0","1","2"},from);
        from= verifyTargetsRanInLoop(new String[]{"0","2","4"},from);
        from= verifyTargetsRanInLoop(new String[]{"-1","0"},from);
    }

    public void testListLoopControl()
    {
        runTarget("testListLoopControl");
        int from=0;
        from= verifyTargetsRanInLoop(new String[]{"a","b","c"},from);
        from= verifyTargetsRanInLoop(new String[]{"w","x","y","z"},from);
        from= verifyTargetsRanInLoop(new String[]{"${p.unknown}"},from);
    }

    public void testItemListLoopControl_AntX03()
    {
        runTarget("testItemListLoopControl_AntX03");
    }

    public void testInFileLoopControl()
    {
        runTarget("testInFileLoopControl");
    }

    public void testDirsetLoopControl()
    {
        runTarget("testDirsetLoopControl");
    }

    public void testPathLoopControl()
    {
        runTarget("testPathLoopControl");
    }

    public void testFilesetLoopControl()
    {
        runTarget("testFilesetLoopControl");
    }

//      public void testSupportsIfUnless()
//      {
//          runTarget("testFailIfUnless");
//      }

    public void testSupportsTryEach()
    {
        runTarget("testSupportsTryEach");
    }

    /** @since JWare/AntX 0.4 **/
    public void testNestedPropertySets_AntX04()
    {
        runTarget("testNestedPropertySets_AntX04");
    }
    
    /** @since JWare/AntX 0.4 **/
    public void testLocalMode_AntX04()
    {
        runTarget("testLocalMode_AntX04");
    }
    
    public void testCallLocalMacros_AntX05()
    {
        runTarget("testCallLocalMacros_AntX05");
    }
    
    public void testListLoopCustomDelimiter_AntX05()
    {
        runTarget("testListLoopCustomDelimiter_AntX05");
    }
}

/* end-of-ForEachTaskTest.java */
