/**
 * $Id: MatchLike.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.match;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.StringEquality;

/**
 * Switch choice that matches value-under-test against a predefined regular expression.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 * @see      SwitchTask
 **/

public final class MatchLike extends MatchString
{
    /**
     * Set our string equality check to be RE-based.
     **/
    private void configureTestForRE()
    {
        StringEquality eqT= getTest();
        eqT.setOperator(StringEquality.OP_MATCHES);
    }


    /**
     * Creates new nested MatchLike instance.
     **/
    public MatchLike()
    {
        super(AntX.flow+"switch");
        configureTestForRE();
    }


    /**
     * Set the will-trim option of the switch value. The choice's
     * regular expression will <em>not</em> be touched.
     * @param trim <i>true</i> if switch value should be trimmed before test
     **/
    public void setTrim(boolean trim)
    {
        getTest().getUnknownValueGetter().setTrim(trim);
    }


    /**
     * Set the case-sensitivity of the switch value. The choice's
     * regular expression will <em>not</em> be touched.
     * @param ignore <i>true</i> if comparision should be case insensitive
     **/
    public void setIgnoreCase(boolean ignore)
    {
        getTest().getUnknownValueGetter().setIgnoreCase(ignore);
    }
}

/* end-of-MatchLike.java */
