/**
 * $Id: EmitTestSkeleton.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback.tests;

import  java.text.DateFormat;

import  org.apache.log4j.Logger;
import  org.apache.log4j.LogManager;
import  org.apache.log4j.spi.RendererSupport;

import  com.idaremedia.antx.ErrorSnapshot;
import  com.idaremedia.antx.feedback.ErrorSnapshotRenderer;
import  com.idaremedia.antx.helpers.DateTimeFormat;
import  com.idaremedia.antx.ut.HTC;


/**
 * Helper class for EmitTask and EmitConfigureTask tests.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public abstract class EmitTestSkeleton extends HTC
{
    /**
     * Create new EmitTestSkeleton testcase.
     **/
    public EmitTestSkeleton(String grpId,String methodName)
    {
        super(grpId,methodName);
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected DateFormat m_dateFormatter;
    protected EchoAppender m_testAppender=null;
    protected String m_testLoggerCategory=null;


    protected final Logger whichLogger(String grpId)
    {
        return (grpId==null) ? Logger.getRootLogger() : Logger.getLogger(grpId);
    }

    protected final EchoAppender testAppender()
    {
        assertNotNil(m_testAppender,"Attached Test Appender");
        return m_testAppender;
    }

    protected final int getIntegerProperty(String pn)
    {
        String s = getProject().getProperty(pn);
        try {
            return Integer.parseInt(s);
        } catch(Exception anyX) {
            fail("Unable to parse number-property("+pn+" = "+s+")");
        }
        return 0;//4-compiler
    }

    protected final String getTodayString()
    {
        return m_dateFormatter.format(new java.util.Date());
    }

    protected void attachTestAppender(String grpId)
    {
        Logger l = whichLogger(grpId);
        EchoAppender echo = new EchoAppender();
        l.addAppender(echo);
        m_testAppender = echo;
        m_testLoggerCategory = grpId;
    }

    protected String runEchoedTarget(String target)
    {
        attachTestAppender("jware");
        String antLog= runTarget(target);
        println("\nLog4J's Appender LLLOOOGGG: ----",testAppender().getLog());
        return antLog;
    }

    protected String runEchoedTarget(String target, String grpId)
    {
        attachTestAppender(grpId);
        String antLog= runTarget(target);
        println("\nLog4J's Appender LLLOOOGGG: ----",testAppender().getLog());
        return antLog;
    }

    protected final void ensureErrorSnapshotRendererInstalled()
    {
        // *** THIS DOES NOT WORK THROUGH TO ANT SINCE JUNIT      \\
        //     LOADS TESTS WITH OWN CLASSLOADER AND ANT LOADS     \\
        //     TASKS/PROJECTS WITH DIFFERENT CLASSLOADER(S)   *** \\

        Logger lgr= LogManager.getRootLogger();
        if (lgr.getLoggerRepository() instanceof RendererSupport) {
            RendererSupport api = (RendererSupport)lgr.getLoggerRepository();
            Object r = api.getRendererMap().get(ErrorSnapshot.class);
            if (!(r instanceof ErrorSnapshotRenderer)) {
                println("[***] Installing ErrorSnapshot ObjectRenderer!");
                api.setRenderer(ErrorSnapshot.class, new ErrorSnapshotRenderer());
            }
        }
    }

    protected void setUp() throws Exception
    {
        super.setUp();
        ensureErrorSnapshotRendererInstalled();
        configureProjectFromResource(getDefaultConfigureXMLFileName());
        m_dateFormatter = (DateFormat)DateTimeFormat.ABBREV_DATE.clone();
    }

    protected void tearDown() throws Exception
    {
        if (m_testAppender!=null) {
            Logger l= whichLogger(m_testLoggerCategory);
            l.removeAppender(m_testAppender);
        }
        super.tearDown();
    }

    protected abstract String getDefaultConfigureXMLFileName();

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }
}

/* end-of-EmitTestSkeleton.java */
