/**
 * $Id: ItemConstructionTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.construct.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Test suite for the trio of item construction tasks: 
 * {@linkplain com.idaremedia.antx.construct.CreateTaskTask}, 
 * {@linkplain com.idaremedia.antx.construct.AlterTaskTask}, and
 * {@linkplain com.idaremedia.antx.construct.PerformTaskTask}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class ItemConstructionTest extends HTC 
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Initializes new ItemConstructionTest testcase.
     **/
    public ItemConstructionTest(String methodName)
    {
        super("ItemConstruction::",methodName);
    }


    /**
     * Creates full test suite for CreaetTaskTask, AlterTaskTask,
     * and PerformTaskTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ItemConstructionTest.class);
    }


    /**
     * Creates baseline test suite.
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test suite (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("itemconstruct.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }
    
    public void testCanBeginConstructDataTypes_AntX05()
    {
        runTarget("testCanBeginConstructDataTypes_AntX05");
    }
    
    public void testCanBeginConstructTasks_AntX05()
    {
        runTarget("testCanBeginConstructTasks_AntX05");
    }
    
    public void testAddNestedElementToTaskInstance_AntX05()
    {
        runTarget("testAddNestedElementToTaskInstance_AntX05");
    }
    
    public void testAddManyNestedElementsToTaskInstance_AntX05()
    {
        runTarget("testAddManyNestedElementsToTaskInstance_AntX05");
    }
    
    public void testCanBlockOverwrite_AntX05()
    {
        runTarget("testCanBlockOverwrite_AntX05");
    }
    
    public void testCanSpecifyNameAttribute_AntX05()
    {
        runTarget("testCanSpecifyNameAttribute_AntX05");
    }
    
    public void testCanReuseTaskDefinition_AntX05()
    {
        runTarget("testCanReuseTaskDefinition_AntX05");
    }
    
    public void testCanResolvePropertiesNowInAlterTask_AntX05()
    {
        runTarget("testCanResolvePropertiesNowInAlterTask_AntX05");
    }
    
    public void testCanAddNestedElementsAsGrandchild_AntX05()
    {
        runTarget("testCanAddNestedElementsAsGrandchild_AntX05");
    }
    
    public void testCanAddNestedElementsAsGreatGrandchild_AntX05()
    {
        runTarget("testCanAddNestedElementsAsGreatGrandchild_AntX05");
    }
}

/* end-of-ItemConstructionTest.java */