/**
 * $Id: EqualFields.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.ProjectComponent;
import  org.apache.tools.ant.taskdefs.condition.Condition;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AssertableProjectComponent;
import  com.idaremedia.antx.helpers.Strings;

/**
 * Diagnostics condition that verifies two fields on two different objects are equivalent.
 * Can also be configured to verify that a single object field is <i>null</i>.
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,test,helper
 * @see      AssertTask
 **/

final class EqualFields extends AssertableProjectComponent
    implements Condition
{
    /**
     * Initializes a new EqualFields condition.
     **/
    EqualFields()
    {
        super(AntX.conditions);
        initFields();
    }


    /**
     * Initializes a new CV-labeled EqualFields condition.
     * @param iam CV-label (non-null)
     **/
    EqualFields(String iam)
    {
        super(iam);
        initFields();
    }


    /**
     * Sets the name of the first reference.
     * @param refid reference identifier (non-null)
     **/
    void setItem1(String refid)
    {
        require_(refid!=null,"setItem1- nonzro refid");
        m_item1 = refid;
    }


    /**
     * Returns reference identifier for first item. Returns
     * <i>null</i> if never set.
     **/
    String getItem1()
    {
        return (m_item1==__NULL1) ? null : m_item1;
    }


    /**
     * Sets the name of the second reference. Pass the string
     * "null" for null comparison.
     **/
    void setItem2(String refid)
    {
        if (refid==null || Strings.NULL.equalsIgnoreCase(refid)) {
            m_item2 = null;
        } else {
            m_item2 = refid;
        }
    }


    /**
     * Returns reference identifier for second item. Returns
     * <i>null</i> if never set. Returns the string "null" if
     * will used as <i>null</i>.
     **/
    String getItem2()
    {
        return (m_item2==__NULL2) ? null :
            (m_item2==null) ? Strings.NULL : m_item2;
    }


    /**
     * Returns project field for given reference item. Can be easily
     * genericized to look for any field if this is ever useful.
     * @throws BuildException if field not properly specified
     **/
    private Object getItemField(String refid, boolean refRequired)
    {
        if (refid==null || refid==__NULL1 || refid==__NULL2) {
            if (refRequired) {
                String ermsg = uistrs().get("brul.assert.samefield.need.item");
                log(ermsg,Project.MSG_ERR);
                throw new BuildException(ermsg);
            }
            return refid==null ? null : getProject();
        }
        //NB: Would generalize to use reflection here (ssmc)\\
        Object obj = getProject().getReference(refid);

        if (!(obj instanceof ProjectComponent)) {
            String ermsg = uistrs().get("brul.assert.samefield.missing.field",
                                        refid, "Project");
            log(ermsg,Project.MSG_ERR);
            throw new BuildException(ermsg);
        }
        return ((ProjectComponent)obj).getProject();
    }


    /**
     * Returns <i>true</i> if the two objects have equivalent projects.
     * @throws BuildException if not properly defined
     **/
    public boolean eval()
    {
        verifyInProject_("eval");
        Object P1 = getItemField(m_item1,true);
        Object P2 = getItemField(m_item2,false);
        return equalObjects(P1,P2,true);
    }


    /**
     * Returns <i>true</i> if a equals b. Handles nulls. Does not handle
     * Java arrays.
     **/
    static boolean equalObjects(Object a, Object b, boolean identical)
    {
        if (a==null) {
            return b==null;
        }
        if (b==null) {
            return false;
        }
        if (a==b) {
            return true;
        }
        return identical ? false : a.equals(b);
    }


    /**
     * Allows us to initializes the two fields to something that isn't
     * <i>null</i> but that won't match anything user likely to specify.
     **/
    private static final String __NULL1, __NULL2; //NB: make different
    static {
        StringBuffer sb = new StringBuffer
            (String.valueOf(System.identityHashCode(EqualFields.class)));
        sb.append("_");
        __NULL1 = sb.substring(0);
        sb.append("_");
        __NULL2 = sb.substring(0);
        sb = null;
    }
    private void initFields()
    {
        m_item1 = __NULL1;
        m_item2 = __NULL2;
    }

    private String m_item1, m_item2;
}

/* end-of-EqualFields.java */
