/**
 * $Id: ShortHandConditions.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  java.io.File;

import  org.apache.tools.ant.types.Reference;
import  org.apache.tools.ant.types.Path;

import  com.idaremedia.antx.parameters.IgnoreCaseEnabled;
import  com.idaremedia.antx.parameters.IgnoreWhitespaceEnabled;
import  com.idaremedia.antx.parameters.MalformedCheckEnabled;
import  com.idaremedia.antx.parameters.TrimEnabled;
import  com.idaremedia.antx.parameters.FlexValueSupport;
import  com.idaremedia.antx.parameters.IsA;

/**
 * Collection of most common shorthand condition parameters supported by
 * AntX rule tasks. The various "*Enabled" and the FlexValue support modify the
 * primary shorthand condition.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2003-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,infra
 **/

public interface ShortHandConditions
    extends FlexValueSupport, IgnoreCaseEnabled, TrimEnabled,
            IgnoreWhitespaceEnabled, MalformedCheckEnabled
{
    /**
     * Parameter shorthand for a single &lt;istrue&gt; condition.
     **/
    void setIsTrue(String name);

    /**
     * Parameter shorthand for a single &lt;isfalse&gt; condition.
     **/
    void setIsFalse(String name);



    /**
     * Parameter shorthand for a single &lt;isnotwhitespace&gt;
     * condition.
     **/
    void setIsNotWhitespace(String name);

    /**
     * Parameter shorthand for a single &lt;isnumeric&gt; condition.
     **/
    void setIsNumeric(String name);

    /**
     * Parameter shorthand for a single &lt;isboolean&gt; condition.
     **/
    void setIsBoolean(String name);



    /**
     * Parameter shorthand for a single &lt;isset&gt; condition.
     **/
    void setIsSet(String name);

    /**
     * Parameter shorthand for a single &lt;issettrue&gt; condition.
     **/
    void setIsSetTrue(String name);

    /**
     * Modifier for a shorthand &lt;isboolean&gt; or &lt;issettrue&gt;
     * condition.
     **/
    void setSynonyms(boolean allowAll);

    /**
     * Parameter shorthand for a single &lt;isnotset&gt; condition.
     **/
    void setIsNotSet(String name);

    /**
     * Source modifier for various shorthand &lt;isXXX&gt; conditions.
     **/
    void setIsA(IsA isa);



    /**
     * Parameter shorthand for a single &lt;isset isa="variable"&gt;
     * condition.
     **/
    void setVarSet(String name);

    /**
     * Parameter shorthand for a single &lt;issettrue isa="variable"&gt;
     * condition.
     **/
    void setVarSetTrue(String name);

    /**
     * Parameter shorthand for a single &lt;isnotset isa="variable"&gt;
     * condition.
     **/
    void setVarNotSet(String name);



    /**
     * Parameter shorthand for a single &lt;allset&gt; condition.
     **/
    void setAllSet(String properties);

    /**
     * Parameter shorthand for a single &lt;anyset&gt; condition.
     **/
    void setAnySet(String properties);

    /**
     * Parameter shorthand for a single &lt;noneset&gt; condition.
     **/
    void setNoneSet(String properties);



    /**
     * Parameter shorthand for a single &lt;matches&gt; condition.
     **/
    void setMatches(String pattern);

    /**
     * Defines literal value used in a string matching condition.
     **/
    void setValue(String literal);



    /**
     * Parameter shorthand for a single &lt;available file="&#46;&#46;&#46;"&gt;
     * condition.
     **/
    void setIsFile(File file);

    /**
     * Parameter shorthand for a single &lt;available file="&#46;&#46;&#46;" type="dir"&gt;
     * condition.
     **/
    void setIsDirectory(File file);

    /**
     * Defines the path used to search for file or directory in an
     * &lt;available&gt; shorthand condition.
     **/
    void setFilepath(Path filp);

    /**
     * Parameter shorthand for a single &lt;available classname="&#46;&#46;&#46;"&gt;
     * condition.
     **/
    void setIsClass(String classname);

    /**
     * Parameter shorthand for a single &lt;available resource="&#46;&#46;&#46;"&gt;
     * condition.
     **/
    void setIsResource(String name);

    /**
     * Defines the classpath used to search for a class or resource in
     * an &lt;available&gt; shorthand condition.
     **/
    void setClasspath(Path clsp);

    /**
     * Defines the classpath reference used to search for a class or
     * resource in an &lt;available&gt; shorthand condition.
     **/
    void setClasspathRef(Reference cpr);

    /**
     * Defines whether system classes included in classpath used to
     * search for classes or resources in an &lt;available&gt; shorthand
     * condition.
     **/
    void setSystemClasses(boolean included);



    /**
     * Parameter shorthand for a single &lt;os family="&#46;&#46;&#46;"&gt; condition.
     **/
    void setOSFamily(String family);

    /**
     * Parameter shorthand for a single AntX
     * <span class="src">ifOS="&#46;&#46;&#46;"</span> condition.
     * @since JWare/AntX 0.4
     **/
    void setOS(String selector);



    /**
     * Parameter shorthand for a single &lt;httpalive url="&#46;&#46;&#46;"&gt;
     * condition.
     * @since JWare/AntX 0.3
     **/
    void setHttpAlive(String url);
}

/* end-of-ShortHandConditions.java */
