/**
 * $Id: LocalPropertyExaminer.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.FlexString;
import  com.idaremedia.antx.helpers.NameValuePair;
import  com.idaremedia.antx.ownhelpers.PropertyExaminer;
import  com.idaremedia.antx.ownhelpers.UnresolvedProperty;

/**
 * A utility singleton that examines flexvalue properties to unresolved bits.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 **/

final class LocalPropertyExaminer
{
    /**
     * Worker bee.
     **/
    private static final PropertyExaminer EXAMINER
        = new PropertyExaminer();
    static {
        EXAMINER.setCheckBrokenSubstitution();
    }


    /**
     * Verify a property definition's current value.
     **/
    static boolean verifyProperty(Project P, FlexString propertydef) {
        String name  = propertydef.sourceString(P);
        String value = propertydef.targetString(P,name);
        boolean ok = value!=null && value!=UnresolvedProperty.VALUE;
        if (ok) {
            NameValuePair nvp= new NameValuePair();
            nvp.setName(name);
            nvp.setValue(value);
            ok = EXAMINER.verifiedPropertyValue(nvp,P)!=null;
        }
        return ok;
    }


    /**
     * Verify a project property's current value.
     **/
    static boolean verifyProperty(Project P, String property) {
        String value = P.getProperty(property);
        boolean ok = value!=null;
        if (ok) {
            NameValuePair nvp= new NameValuePair();
            nvp.setName(property);
            nvp.setValue(value);
            ok = EXAMINER.verifiedPropertyValue(nvp,P)!=null;
        }
        return ok;
    }


    /**
     * Verify an in-place "literal" value.
     **/
    static boolean verifyLiteral(Project P, String literal) {
        return EXAMINER.verifiedLiteral(literal,P);
    }


    /**
     * Verify an in-place "literal" definition.
     **/
    static boolean verifyLiteral(Project P, FlexString literaldef) {
        return EXAMINER.verifiedLiteral(literaldef.sourceString(P),P);
    }


    /**
     * Prevented.
     **/
    private LocalPropertyExaminer()
    {
    }
}

/* end-of-LocalPropertyExaminer.java */
