/**
 * $Id: IsClass.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.taskdefs.Available;
import  org.apache.tools.ant.taskdefs.condition.Condition;
import  org.apache.tools.ant.types.Path;
import  org.apache.tools.ant.types.Reference;

import  com.idaremedia.antx.AssertableProjectComponent;
import  com.idaremedia.antx.helpers.Strings;

/**
 * Adapter that allows &lt;available class="&#46;&#46;&#46;"/&gt; to be inlined in
 * boolean rules as &lt;require isclass="&#46;&#46;&#46;"/&gt;. Delegates to a private
 * Available condition.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single (see Available)
 * @.group   impl,helper
 * @.pattern GoF.Adapter
 **/

public final class IsClass extends AssertableProjectComponent 
    implements Condition, URIable
{
    /**
     * Creates new IsClass condition.
     **/
    public IsClass()
    {
        m_impl = new Available();
    }



    /**
     * Creates a new pre-initialized IsClass condition.
     * @param value resource name/path to be located.
     * @see #setName
     **/
    public IsClass(String value)
    {
        this();
        setName(value);
    }



    /**
     * Sets this condition's project; updates underlying available
     * condition too.
     **/
    public void setProject(Project p)
    {
        super.setProject(p);
        m_impl.setProject(p);
    }



    /**
     * Sets the name of the class to be located.
     * @param classname class name (non-null)
     **/
    public void setName(String classname)
    {
        require_(classname!=null,"setval- nonzro clazname");
        m_impl.setClassname(classname);
    }



    /**
     * Set the classpath to be used when searching for the class.
     * @param classpath an search path (non-null)
     */
    public void setClasspath(Path classpath)
    {
        require_(classpath!=null,"setCP- nonzro cp");
        m_impl.setClasspath(classpath);
    }



    /**
     * Like {@linkplain #setClasspath setClasspath} but by reference.
     * @param r a Reference to a Path instance to be used as classpath (non-null)
     */
    public void setClasspathRef(Reference r)
    {
        require_(r!=null,"setCPref- nonzro cp refid");
        m_impl.setClasspathRef(r);
    }



    /**
     * Sets whether Ant's runtime classes will be included in search
     * classpath. "<i>true</i>" by default.
     * @param include <i>false</i> if Ant's classes excluded
     */
    public void setSystemClasses(boolean include)
    {
        m_impl.setIgnoresystemclasses(!include);
    }



    /**
     * Sets property name updated by <i>true</i> evaluation.
     * @param property the property's name (non-null)
     * @since JWare/AntX 0.3
     **/
    public void setTrueProperty(String property)
    {
        require_(property!=null,"setTrueProp- nonzro name");
        m_updateProperty = property;//NB:don't use available's property
    }



    /**
     * Returns property name updated by evaluation method. Returns
     * <i>null</i> if never set or value is an exported property.
     * @since JWare/AntX 0.3
     **/
    public final String getTrueProperty()
    {
        return m_updateProperty;
    }



    /**
     * Sets this condition's target class name as part of a
     * value URI.
     * @param fragment the value uri bits (non-null)
     * @since JWare/AntX 0.5
     */
    public void xsetFromURI(String fragment)
    {
        setName(fragment);
    }



    /**
     * Checks whether given class exists (and is loadable) or not.
     * @throws BuildException if incomplete set or unable to check condition
     **/
    public boolean eval() throws BuildException
    {
        verifyInProject_("eval");

        boolean istrue = m_impl.eval();

        if (istrue && m_updateProperty!=null) {
            log("IsClass was true; setting true-property '"+m_updateProperty+
                "' property",  Project.MSG_DEBUG);
            getProject().setNewProperty(m_updateProperty,Strings.TRUE);
        }

        return istrue;
    }


    private Available m_impl;
    private String m_updateProperty;
}

/* end-of-IsClass.java */
