/**
 * $Id: InterpretLoggedTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Test suite for {@linkplain com.idaremedia.antx.capture.InterpretLoggedTask
 * InterpretLoggedTask}.
 *
 * @since    JWare/AntX 0.5
 * @author   ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/
public final class InterpretLoggedTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new InterpretLoggedTaskTest testcase.
     **/
    public InterpretLoggedTaskTest(String methodName)
    {
        super("InterpretLoggedTaskTest::",methodName);
    }


    /**
     * Create full test suite for InterpretLoggedTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(InterpretLoggedTaskTest.class);
    }


    /**
     * Create baseline test suite for InterpretLoggedTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("evaluatelog.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }
    
    public void testInterpreterTypedefs_AntX05()
    {
        runTarget("testInterpreterTypedefs_AntX05");
    }

    public void testFullyQualifiedClassAsInterpreter_AntX05()
    {
        runTarget("testFullyQualifiedClassAsInterpreter_AntX05");
    }
    
    public void testRequiredAttributes_AntX05()
    {
        runTarget("testRequiredAttributes_AntX05");
    }
    
    public void testNoFileIsAlwaysClean_AntX05()
    {
        runTarget("testNoFileIsAlwaysClean_AntX05");
    }

    public void testNoDataIsAlwaysChecked_AntX05()
    {
        runTarget("testNoDataIsAlwaysChecked_AntX05");
    }
    
    public void testInterpreterInControl_AntX05()
    {
        runTarget("testInterpreterInControl_AntX05");
    }
    
    public void testFailIllegalResultType_AntX05()
    {
        runTarget("testFailIllegalResultType_AntX05");
    }
    
    public void testFlexResultTypes_AntX05()
    {
        runTarget("testFlexResultTypes_AntX05");
    }
    
    public void testCanReUseVariableResultHolders_AntX05()
    {
        runTarget("testCanReUseVariableResultHolders_AntX05");
    }
    
    public void testCanReUseReferenceResultHolders_AntX05()
    {
        runTarget("testCanReUseReferenceResultHolders_AntX05");
    }

    public void testCanPassthruCustomOptions_AntX05()
    {
        runTarget("testCanPassthruCustomOptions_AntX05");
    }


    public void testJavadocInterpeterWithDefaults_AntX05()
    {
        runTarget("testJavadocInterpeterWithDefaults_AntX05");
    }
    
    public void testJavadocFailsTooManyWarningsNoErrors_AntX05()
    {
        runTarget("testJavadocFailsTooManyWarningsNoErrors_AntX05");
    }
    
    public void testJavadocOnlyProblemsIfUnderMaximums_AntX05()
    {
        runTarget("testJavadocOnlyProblemsIfUnderMaximums_AntX05");
    }



    public void testEmmaFailsWithAnyUnderCoverages_AntX05()
    {
        runTarget("testEmmaFailsWithAnyUnderCoverages_AntX05");
    }
    
    public void testEmmaOnlyProblemsIfUnderMaximums_AntX05()
    {
        runTarget("testEmmaOnlyProblemsIfUnderMaximums_AntX05");
    }
    
    public void testEmmaPassesIfNoEmmaFailures_AntX05()
    {
        runTarget("testEmmaPassesIfNoEmmaFailures_AntX05");
    }
    
    public void testEmmaWarnsIfNoFailuresButUnder75_AntX05()
    {
        runTarget("testEmmaWarnsIfNoFailuresButUnder75_AntX05");
    }
}
/* end-of-InterpretLoggedTaskTest.java */