/**
 * $Id: MimOutputStream.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003,2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture;

import  java.io.IOException;
import  java.io.OutputStream;
import  java.io.PrintStream;

/**
 * An output stream wrapper which saves output to task's buffer
 * before sending on to original stream target (Ant|System).
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003,2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  guarded
 * @.group   impl,helper
 * @see      CopyLoggedTask
 **/

class MimOutputStream extends OutputStream
{
    /**
     * Creates a new filter stream for real system stream.
     **/
    MimOutputStream(PrintStream dest, StringBuffer allBuffer)
    {
        m_outBuffer = new StringBuffer(100);
        m_finalDest = dest;
        m_allBuffer = allBuffer;
    }


    /**
     * Capture the byte to task-related buffer.
     **/
    public void write(int b) throws IOException
    {
        m_outBuffer.append((char)b);
        if (m_allBuffer!=null) {
            m_allBuffer.append((char)b);
        }
        m_finalDest.write(b);
    }


    /**
     * Returns a copy of this filter's current contents.
     **/
    String copyBuffer()
    {
        return m_outBuffer.substring(0);
    }


    /**
     * Resets this filter's buffered contents.
     **/
    void clearBuffer()
    {
        m_outBuffer.delete(0,m_outBuffer.length());
    }

    private final PrintStream m_finalDest;
    private final StringBuffer m_outBuffer, m_allBuffer;
}

/* end-of-MimOutputStream.java */
