/**
 * $Id: InterpretParameters.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture;

import  java.util.Properties;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.parameters.IsA;

/**
 * Standard script-supplied instructions for a log interpretation request. An interpreter
 * does not have to use all the options.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   n/a
 * @.group    impl,helper
 * @see       InterpretLoggedTask
 **/

public interface InterpretParameters extends Requester
{
    /**
     * Returns <i>true</i> if the interpreter should update this
     * requester's project directly. Usually returns <i>true</i>.
     **/
    boolean updateProperties();


    /**
     * Returns the maximum number of errors this interpreter will 
     * tolerate before recording a failure. This value is zero (0)
     * unless defined otherwise.
     **/
    int getMaxErrors();


    /**
     * Returns the maximum number of warnings this interpreter will
     * tolerate before recording a failure. This value is ten (10)
     * unless defined otherwise.
     **/
    int getMaxWarnings();


    /**
     * Returns the name of the property this interpreter will update
     * with its conclusion. Never returns <i>null</i> or the empty 
     * string.
     **/
    String getUpdateProperty();


    /**
     * Returns the name of the property this interpreter will update
     * with the number of errors. Never returns <i>null</i> or the 
     * empty string.
     **/
    String getErrorCountProperty();


    /**
     * Returns the name of the property this interpreter will update
     * with the number of warnings. Never returns <i>null</i> or the
     * empty string.
     **/
    String getWarningCountProperty();



    /**
     * Returns the preferred type of the result set data objects.
     * Defaults to standard properties unless caller sets explicitly.
     * Never returns <i>null</i>.
     **/
    IsA getResultType();



    /**
     * Returns the readonly set of custom properties supplied by
     * client script. Never returns <i>null</i> but can return an
     * empty map.
     **/
    Properties getInstructions();
}

/* end-of-InterpretParameters.java */