/**
 * $Id: BuildAssertionException.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.apis;

import  java.lang.reflect.Constructor;
import  java.lang.reflect.Method;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Location;

/**
 * Failed build assertion exception thrown by any application-controlled fixture and
 * iteration verifying task like the AntX  
 * {@linkplain com.idaremedia.antx.condition.solo.AssertTask AssertTask AssertTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2003-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 * @see      BuildError
 **/

public class BuildAssertionException extends BuildException
{
    /**
     * Creates new default build assertion exception.
     **/
    public BuildAssertionException()
    {
        super("Assertion Failed");
        initJUnitLink();
    }


    /**
     * Creates new custom build assertion exception.
     * @param msg exception's human-readable message (non-null)
     **/
    public BuildAssertionException(String msg)
    {
        super(msg);
        initJUnitLink();
    }


    /**
     * Creates new custom build assertion exception with source
     * location.
     * @param msg exception's human-readable message (non-null)
     * @param location build file location
     **/
    public BuildAssertionException(String msg, Location location)
    {
        super(msg,location);
        initJUnitLink();
    }


    /**
     * Creates new custom build assertion exception based
     * on an existing exception (called the <i>cause</i>).
     * @param msg exception's human-readable message (non-null)
     * @param cause original problem (non-null)
     **/
    public BuildAssertionException(String msg, Throwable cause)
    {
        super(msg,cause);
        initJUnitLink();
    }


    /**
     * Creates new custom build assertion exception based
     * on existing exception (called the <i>cause</i>) and build
     * file location.
     * @param msg exception's human-readable message (non-null)
     * @param cause original problem (non-null)
     * @param location build file location (non-null)
     **/
    public BuildAssertionException(String msg, Throwable cause,
                                   Location location)
    {
        super(msg,cause,location);
        initJUnitLink();
    }


    /**
     * Creates new build assertion exception based on
     * existing exception (called tehe <i>cause</i>).
     * @param cause original problem (non-null)
     **/
    public BuildAssertionException(Throwable cause)
    {
        super(cause);
        initJUnitLink();
    }


    /**
     * Creates new build assertion exception based on
     * existing exception (called the <i>cause</i>) and build
     * file location.
     * @param cause original problem (non-null)
     * @param location build file location (non-null)
     **/
    public BuildAssertionException(Throwable cause, Location location)
    {
        super(cause,location);
        initJUnitLink();
    }



    private static final Class[] AFE_SIG0= new Class[]{String.class};
    private static final Class[] AFE_SIG1= new Class[]{Throwable.class};


    /**
     * Try to create a JUnit-link assertion that includes the
     * real source of the assertion failure.
     * @since JWare/AntX 0.4
     **/
    private void initJUnitLink()
    {
        try {
            //@.impl Use this.toString() to capture location information
            // directly in assertion exception message (ssmc).
            Class c = Class.forName("junit.framework.AssertionFailedError");
            Constructor ctor = c.getConstructor(AFE_SIG0);
            m_linkJUnit = (Throwable)ctor.newInstance(new Object[]{toString()});
            Method m= c.getMethod("initCause",AFE_SIG1);
            m.invoke(m_linkJUnit, new Object[]{this});
        } catch(Exception anyX) {/*burp*/}
    }



    /**
     * Returns this exception's associated JUnit-related failure
     * error. Will return <i>null</i> if was unable to create this
     * link. If not <i>null</i> the returned throwable is of type
     * <span class="src">junit.framework.AssertionFailedError</span>.
     * @since JWare/AntX 0.4
     **/
    public final Throwable getJUnitLink()
    {
        return m_linkJUnit;
    }


    private Throwable m_linkJUnit;
}


/* end-of-BuildAssertionException.java */
