<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">
  <xsl:output method="html"/>

  <xsl:template match="/">
<html>
<meta charset="utf-8" />
<style>
  path {
    stroke: #fff;
    fill-rule: evenodd;
  }

  text {
    font-family: Arial, sans-serif;
    font-size: 12px;
  }
</style>
<body>
<script src="http://d3js.org/d3.v3.min.js"></script>
<script>
<xsl:apply-templates/>

var width = 960,
    height = 700,
    radius = Math.min(width, height) / 2;

var x = d3.scale.linear().range([0, 2 * Math.PI]);
var y = d3.scale.linear().range([0, radius]);
var color = d3.scale.category20c();

var svg = d3.select("body").append("svg")
    .attr("width", width)
    .attr("height", height)
    .append("g")
    .attr("transform", "translate(" + width / 2 + "," + (height / 2 + 10) + ")");

var partition = d3.layout.partition()
    .value(function(d) { return d.size; });

var arc = d3.svg.arc()
    .startAngle(function(d) { return Math.max(0, Math.min(2 * Math.PI, x(d.x))); })
    .endAngle(function(d) { return Math.max(0, Math.min(2 * Math.PI, x(d.x + d.dx))); })
    .innerRadius(function(d) { return Math.max(0, y(d.y)); })
    .outerRadius(function(d) { return Math.max(0, y(d.y + d.dy)); });

root = JSON.parse(dataString);

var g = svg.selectAll("g")
    .data(partition.nodes(root))
    .enter().append("g");

var path = g.append("path")
    .attr("d", arc)
    .style("fill", function(d) { return color((d.children ? d : d.parent).name); })
    .on("click", click);

var text = g.append("text")
    .attr("transform", function(d) { return "rotate(" + computeTextRotation(d) + ")"; })
    .attr("x", function(d) { return y(d.y); })
    .attr("dx", "6") // margin
    .attr("dy", ".35em") // vertical-align
    .text(function(d) { return d.name; });

function click(d) {
  // fade out all text elements
  text.transition().attr("opacity", 0);
  path.transition()
      .duration(750)
      .attrTween("d", arcTween(d))
      .each("end", function(e, i) {
        // check if the animated element's data e lies within the visible angle span given in d
        if (e.x >= d.x &amp;&amp; e.x &lt; (d.x + d.dx)) {
        // get a selection of the associated text element
        var arcText = d3.select(this.parentNode).select("text");
        // fade in the text element and recalculate positions
        arcText.transition().duration(750)
               .attr("opacity", 1)
               .attr("transform", function() { return "rotate(" + computeTextRotation(e) + ")" })
               .attr("x", function(d) { return y(d.y); });
        }
      });
}

d3.select(self.frameElement).style("height", height + "px");

// Interpolate the scales!
function arcTween(d) {
  var xd = d3.interpolate(x.domain(), [d.x, d.x + d.dx]),
  yd = d3.interpolate(y.domain(), [d.y, 1]),
  yr = d3.interpolate(y.range(), [d.y ? 20 : 0, radius]);
  return function(d, i) {
    return i
    ? function(t) { return arc(d); }
    : function(t) { x.domain(xd(t)); y.domain(yd(t)).range(yr(t)); return arc(d); };
  };
}

function computeTextRotation(d) {
  return (x(d.x + d.dx / 2) - Math.PI / 2) / Math.PI * 180;
}

</script>
</body>
</html>
  </xsl:template>

  <xsl:template match="sunburst">
    <xsl:variable name="dataString">
    var dataString = '
    <xsl:apply-templates/>
    ';
    </xsl:variable>
    <xsl:value-of select="normalize-space(translate($dataString,'  ', ' '))"/>
  </xsl:template>

  <xsl:template match="entry">
   {"name": "<xsl:value-of select="tokenize(@path,'/')[last()]"/>",
   <xsl:variable name="next" select="./following-sibling::entry[1]" />
   <!-- Check when there is a gap between current and next -->
   <xsl:choose>
   <xsl:when test="contains($next/@path, @path)">
   <!-- Next sibling is child path -->
   "children" : [
   </xsl:when>
   <xsl:when test="number($next/@level) = number(@level)">
   <!-- Next sibling is at same level -->
   "size": <xsl:value-of select="@size"/>},
   </xsl:when>
   <xsl:when test="number($next/@level) > number(@level)">
   <!-- Next sibling is at higher level -->
   "size": <xsl:value-of select="@size"/>}, "children" : [
   </xsl:when>
   <xsl:otherwise>
   <!-- Next sibling is at lower level or the last -->
   "size": <xsl:value-of select="@size"/>}
     <!--
      If exist a next, then to last ']}' it should add a comma, such as, ']},'
      If not, only print ']}'
      -->
     <xsl:variable name="level-to" select="if ($next) then ($next/@level + 1) else 0"/>
     <xsl:call-template name="printStringNTime">
       <xsl:with-param name="output" select="']}'" />
       <xsl:with-param name="count" select="(@level - $level-to)" />
     </xsl:call-template>
     <xsl:value-of select="if ($next) then ']},' else '' "/>
   </xsl:otherwise>
   </xsl:choose>

   <!-- Next entry contain all of this current path -->
   <!-- "children" : [ -->

   <!-- Next entry contain parent path and something -->
   <!-- "size": <xsl:value-of select="@size"/>}, -->

   <!-- Next entry contain parent or part of path -->
   <!-- "size": <xsl:value-of select="@size"/>} -->
   <!-- ]} -->
   <!-- , -->

  </xsl:template>

  <xsl:template name="printStringNTime">
    <xsl:param name="output" />
    <xsl:param name="count" />
    <xsl:if test="$count &gt; 0">
      <xsl:value-of select="$output" />
      <xsl:call-template name="printStringNTime">
        <xsl:with-param name="output" select="$output" />
        <xsl:with-param name="count" select="$count - 1" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>