<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">
  <xsl:output method="html"/>

  <xsl:template match="/">
<html>
  <head>
    <script type="text/javascript" src="https://www.google.com/jsapi"></script>
    <script type="text/javascript">
      google.load("visualization", "1.1", {packages:["sankey"]});
      google.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'From');
        data.addColumn('string', 'To');
        data.addColumn('number', 'Weight');

<xsl:apply-templates/>


        // Sets chart options.
        var options = {
          width: 1024,
        };

        // Instantiates and draws our chart, passing in some options.
        var chart = new google.visualization.Sankey(document.getElementById('sankey_basic'));
        chart.draw(data, options);
      }
    </script>
  </head>
  <body>
    <div id="sankey_basic" style="width: 1024px; height: 900px;"></div>
  </body>
</html>
  </xsl:template>

  <xsl:template match="sankey">
data.addRows([
    <xsl:apply-templates/>
]);
  </xsl:template>

  <xsl:template match="entry">
["<xsl:value-of select="@from"/>", "<xsl:value-of select="@to"/>", <xsl:value-of select="@weight"/>] <xsl:value-of select="if (position()=last()) then '' else ','"/>
  </xsl:template>

</xsl:stylesheet>