<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">

  <xsl:param name="version" />

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="xpaths">
    <sunburst>
      <xsl:apply-templates/>
    </sunburst>
  </xsl:template>

  <xsl:template match="xpath">
    <xsl:variable name="name" select="if (starts-with (@name,'/')) then substring-after(@name,'/') else @name"/>
    <xsl:variable name="level" select="count(tokenize($name,'/'))-1"/>
    <entry path="{$name}" size="{@found}" level="{$level}" />
  </xsl:template>
</xsl:stylesheet>