<?xml version="1.0"?>
<!--
  This schematron defines the rules used for the template namespace in a PSML URL template configuration file.

  @version 5.9900
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <!-- define namespace -->
  <sch:ns uri="http://pageseeder.com/psml/template" prefix="t" />

  <sch:title>Document template namespace validation</sch:title>

  <!--
    Set of rules applying to the template elements
  -->
  <sch:pattern>
    <sch:title>Elements</sch:title>

    <sch:rule context="document">

      <!-- Attribute 'level' on element 'document' must equal 'metadata'  -->
      <sch:assert test="@level='metadata'">Attribute 'level' on element 'document' must equal 'metadata'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:param">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:param'.</sch:assert>

      <!-- Only attributes are name, default and type -->
      <sch:assert test="empty(@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type'])">Invalid attribute '<sch:value-of
        select="@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type']/name()"
        />' on t:param element, only 'name', 'title', 'default' and 'type' are allowed.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:param'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:value">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:value'.</sch:assert>

      <!-- Only attribute is name -->
      <sch:assert test="empty(@*[name() != 'name'])">Invalid attribute '<sch:value-of select="@*[name() != 'name']/name()"
        />' on t:value element, only 'name' is allowed.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:value'.</sch:assert>

    </sch:rule>

   <sch:rule context="t:*">

     <!-- Elements starting with t: must be one of t:param, t:value, t:fragment, t:fragment-ref -->
     <sch:assert test="local-name(.)='param' or local-name(.)='value'">Invalid element 't:<sch:value-of
       select="local-name(.)" />' only 't:param' and 't:value' are allowed.</sch:assert>

   </sch:rule>

  </sch:pattern>

</sch:schema>