<?xml version="1.0"?>
<!--
  This schematron defines the rules used for the template namespace in a PSML document template configuration file.

  @version 5.8200
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <!-- define namespace -->
  <sch:ns uri="http://pageseeder.com/psml/template" prefix="t" />

  <sch:title>Document template namespace validation</sch:title>

  <!--
    Set of rules applying to the template elements
  -->
  <sch:pattern>
    <sch:title>Elements</sch:title>

    <sch:rule context="t:param">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:param'.</sch:assert>

      <!-- Only attributes are name, default, type and description-->
      <sch:assert test="empty(@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type'][name() != 'description'])">Invalid attribute '<sch:value-of
        select="@*[name() != 'name'][name() != 'title'][name() != 'default'][name() != 'type']/name()"
        />' on t:param element '<sch:value-of select="@name"/>', only 'name', 'title', 'default', 'type' and 'description' are allowed.</sch:assert>

      <!-- Type xml cannot have default attribute -->
      <sch:assert test="not(@type) or @type != 'xml' or not(@default)">Invalid attribute 'default'
        on t:param element  '<sch:value-of select="@name"/>' which is not allowed when type="xml".</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in t:param element '<sch:value-of select="@name"/>'.</sch:assert>

      <!-- Parent must be document or t:fragment element -->
      <sch:assert test="parent::document | parent::t:fragment">Parent of t:param element '<sch:value-of select="@name"/>' must be document or t:fragment element.</sch:assert>

    </sch:rule>

    <sch:rule context="t:value">

      <!-- Attribute name is required -->
      <sch:assert test="@name">Missing required attribute 'name' on element 't:value'.</sch:assert>

      <!-- Only attribute is name -->
      <sch:assert test="empty(@*[name() != 'name'])">Invalid attribute '<sch:value-of select="@*[name() != 'name']/name()"
        />' on t:value element, only 'name' is allowed.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:value'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:fragment">

      <!-- Attribute type is required -->
      <sch:assert test="@type">Missing required attribute 'type' on element 't:fragment'.</sch:assert>

      <!-- Attribute title is required -->
      <sch:assert test="@title">Missing required attribute 'title' on element 't:fragment'.</sch:assert>

      <!-- Only attribute is type -->
      <sch:assert test="empty(@*[name() != 'type'][name() != 'title'])">Invalid attribute '<sch:value-of select="@*[name() != 'type'][name() != 'title']/name()"
        />' on t:fragment element, only 'type' and 'title' are allowed.</sch:assert>

      <!-- only fragment children allowed -->
      <sch:assert test="empty(*[not(contains(local-name(), 'fragment')) and
                              not(self::t:description) and
                              not(self::t:param)])">Only fragment, t:description and t:param elements are allowed as children of element 't:fragment'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:fragment-ref">

      <!-- Attribute id is required -->
      <sch:assert test="@id">Missing required attribute 'id' on element 't:fragment-ref'.</sch:assert>

      <!-- Attribute type is required -->
      <sch:assert test="@type">Missing required attribute 'type' on element 't:fragment-ref'.</sch:assert>

      <!-- Only attributes are id and type -->
      <sch:assert test="empty(@*[name() != 'id'][name() != 'type'])">Invalid attribute '<sch:value-of
        select="@*[name() != 'id'][name() != 'type']/name()"
        />' on 't:fragment-ref' element, only 'id' and 'type' are allowed.</sch:assert>

      <!-- Attribute type must match a defined type -->
      <sch:assert test="//t:fragment[@type = current()/@type]">Invalid 'type' attribute value on element
        't:fragment-ref', no fragment found with type '<sch:value-of select="@type" />'.</sch:assert>

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:fragment-ref'.</sch:assert>

    </sch:rule>

    <sch:rule context="t:description">

      <!-- no children allowed -->
      <sch:assert test="empty(*)">No children elements allowed in element 't:description'.</sch:assert>

    </sch:rule>

   <sch:rule context="t:*">

     <!-- Elements starting with t: must be one of t:param, t:value, t:fragment, t:description, t:fragment-ref -->
     <sch:assert test="local-name(.)='param' or local-name(.)='value' or
         local-name(.)='fragment' or local-name(.)='description' or local-name(.)='fragment-ref'">Invalid element 't:<sch:value-of
       select="local-name(.)" />' only 't:param', 't:value', 't:fragment' and 't:fragment-ref' are allowed.</sch:assert>

   </sch:rule>

   <sch:rule context="property">

      <!-- Count attribute is deprecated -->
      <sch:assert test="not(@count)">
        The property element "<sch:value-of select="@name" />" has a count attribute which is deprecated (use multiple="true" attribute if required).
      </sch:assert>

      <!-- Only t:description attribute allowed on property -->
      <sch:assert test="empty(@t:*[local-name() != 'description'])">
        The property element "<sch:value-of select="@name" />" has an invalid 't:' attribute, only 't:description' is allowed.
      </sch:assert>

   </sch:rule>

  </sch:pattern>

</sch:schema>