/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class Payload {
    private static final String NO_MEDIATYPE = "";
    private static final Payload EMPTY = new Payload("", new byte[0]);
    private final String mediaType;
    private final byte[] content;

    public Payload(String mediaType, byte[] content) {
        this.mediaType = Objects.toString(mediaType, NO_MEDIATYPE);
        this.content = content;
    }

    public Payload(String mediaType, String content) {
        this(mediaType, content.getBytes(StandardCharsets.UTF_8));
    }

    public Payload(String content) {
        this(NO_MEDIATYPE, content);
    }

    public Payload(byte[] content) {
        this(NO_MEDIATYPE, content);
    }

    public static Payload empty() {
        return EMPTY;
    }

    public String content() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public byte[] bytes() {
        return this.content;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public boolean hasMediaType() {
        return !this.mediaType.isEmpty();
    }

    public String mediaType() {
        return this.mediaType;
    }
}

